/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.IdentifierField;
import adql.query.SelectItem;
import adql.query.from.ADQLTable;
import java.util.NoSuchElementException;

public final class SelectAllColumns
extends SelectItem {
    private ADQLQuery query = null;
    private ADQLTable adqlTable = null;

    public SelectAllColumns(ADQLQuery query) {
        super(null, null);
        this.query = query;
    }

    public SelectAllColumns(ADQLTable table) {
        super(null, null);
        this.adqlTable = table;
    }

    public SelectAllColumns(SelectAllColumns toCopy) throws Exception {
        super(toCopy);
    }

    public final ADQLQuery getQuery() {
        return this.query;
    }

    public final void setQuery(ADQLQuery query) {
        if (query != null) {
            this.query = query;
            this.adqlTable = null;
            this.setPosition(null);
        }
    }

    public final ADQLTable getAdqlTable() {
        return this.adqlTable;
    }

    public final void setAdqlTable(ADQLTable table) {
        if (table != null) {
            this.adqlTable = table;
            this.query = null;
            this.setPosition(null);
        }
    }

    public final ADQLObject getCopy() throws Exception {
        return new SelectAllColumns(this);
    }

    public final String getName() {
        return "*";
    }

    public final ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean tableGot;
            {
                this.tableGot = SelectAllColumns.this.adqlTable == null;
            }

            public ADQLObject next() throws NoSuchElementException {
                if (this.tableGot) {
                    throw new NoSuchElementException();
                }
                this.tableGot = true;
                return SelectAllColumns.this.adqlTable;
            }

            public boolean hasNext() {
                return !this.tableGot;
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (replacer == null) {
                    this.remove();
                } else {
                    if (!this.tableGot) {
                        throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                    }
                    if (!(replacer instanceof ADQLTable)) {
                        throw new IllegalStateException("Impossible to replace an ADQLTable by a " + replacer.getClass().getName() + " !");
                    }
                    SelectAllColumns.this.adqlTable = (ADQLTable)replacer;
                    SelectAllColumns.this.setPosition(null);
                }
            }

            public void remove() {
                if (!this.tableGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the only operand (" + SelectAllColumns.this.adqlTable.toADQL() + ") from a SelectItem (" + SelectAllColumns.this.toADQL() + ") !");
            }
        };
    }

    public final String toADQL() {
        if (this.adqlTable != null) {
            if (this.adqlTable.hasAlias()) {
                return (this.adqlTable.isCaseSensitive(IdentifierField.ALIAS) ? "\"" + this.adqlTable.getAlias() + "\"" : this.adqlTable.getAlias()) + ".*";
            }
            return this.adqlTable.getFullTableName() + ".*";
        }
        return "*";
    }
}

