/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class SelectItem
implements ADQLObject {
    private ADQLOperand operand;
    private String alias = null;
    private boolean caseSensitive = false;
    private TextPosition position = null;

    public SelectItem(ADQLOperand operand) {
        this(operand, null);
    }

    public SelectItem(ADQLOperand operand, String alias) {
        this.operand = operand;
        this.setAlias(alias);
    }

    public SelectItem(SelectItem toCopy) throws Exception {
        this.operand = toCopy.getOperand() != null ? (ADQLOperand)toCopy.getOperand().getCopy() : null;
        this.alias = toCopy.getAlias();
        this.caseSensitive = toCopy.caseSensitive;
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    public final ADQLOperand getOperand() {
        return this.operand;
    }

    public final boolean hasAlias() {
        return this.alias != null;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final void setAlias(String newAlias) {
        if (this.alias == null && newAlias != null || this.alias != null && newAlias == null || this.alias != null && !this.alias.equals(newAlias)) {
            this.position = null;
        }
        this.alias = newAlias;
        this.caseSensitive = false;
        if (this.alias != null) {
            StringBuffer a = new StringBuffer(this.alias);
            a.trimToSize();
            if (a.length() == 0) {
                this.alias = null;
                this.position = null;
                return;
            }
            if (a.length() > 1 && a.charAt(0) == '\"' && a.charAt(a.length() - 1) == '\"') {
                a.deleteCharAt(0);
                a.deleteCharAt(a.length() - 1);
                a.trimToSize();
                if (a.length() == 0) {
                    this.alias = null;
                    this.position = null;
                    return;
                }
                this.caseSensitive = true;
            }
            this.alias = a.toString();
        }
    }

    public final boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public final void setCaseSensitive(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public ADQLObject getCopy() throws Exception {
        return new SelectItem(this);
    }

    public String getName() {
        return this.hasAlias() ? this.alias : this.operand.getName();
    }

    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean operandGot;
            {
                this.operandGot = SelectItem.this.operand == null;
            }

            public ADQLObject next() throws NoSuchElementException {
                if (this.operandGot) {
                    throw new NoSuchElementException();
                }
                this.operandGot = true;
                return SelectItem.this.operand;
            }

            public boolean hasNext() {
                return !this.operandGot;
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (replacer == null) {
                    this.remove();
                } else {
                    if (!this.operandGot) {
                        throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                    }
                    if (!(replacer instanceof ADQLOperand)) {
                        throw new IllegalStateException("Impossible to replace an ADQLOperand by a " + replacer.getClass().getName() + " !");
                    }
                    SelectItem.this.operand = (ADQLOperand)replacer;
                    SelectItem.this.position = null;
                }
            }

            public void remove() {
                if (!this.operandGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the only operand (" + SelectItem.this.operand.toADQL() + ") from a SelectItem (" + SelectItem.this.toADQL() + ") !");
            }
        };
    }

    public String toADQL() {
        StringBuffer adql = new StringBuffer(this.operand.toADQL());
        if (this.hasAlias()) {
            adql.append(" AS ");
            if (this.isCaseSensitive()) {
                adql.append('\"').append(this.alias).append('\"');
            } else {
                adql.append(this.alias);
            }
        }
        return adql.toString();
    }
}

