/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class Between
implements ADQLConstraint {
    private ADQLOperand leftOperand;
    private ADQLOperand minOperand;
    private ADQLOperand maxOperand;
    private boolean notBetween = false;
    private TextPosition position = null;

    public Between(ADQLOperand operand, ADQLOperand min, ADQLOperand max) throws NullPointerException {
        this(operand, min, max, false);
    }

    public Between(ADQLOperand operand, ADQLOperand min, ADQLOperand max, boolean notBetween) throws NullPointerException {
        this.setLeftOperand(operand);
        this.setMinOperand(min);
        this.setMaxOperand(max);
        this.setNotBetween(notBetween);
    }

    public Between(Between toCopy) throws Exception {
        this.setLeftOperand((ADQLOperand)toCopy.leftOperand.getCopy());
        this.setMinOperand((ADQLOperand)toCopy.minOperand.getCopy());
        this.setMaxOperand((ADQLOperand)toCopy.maxOperand.getCopy());
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    public final ADQLOperand getLeftOperand() {
        return this.leftOperand;
    }

    public void setLeftOperand(ADQLOperand leftOperand) throws NullPointerException {
        this.leftOperand = leftOperand;
        this.position = null;
    }

    public final ADQLOperand getMinOperand() {
        return this.minOperand;
    }

    public void setMinOperand(ADQLOperand minOperand) throws NullPointerException {
        this.minOperand = minOperand;
        this.position = null;
    }

    public final ADQLOperand getMaxOperand() {
        return this.maxOperand;
    }

    public void setMaxOperand(ADQLOperand maxOperand) throws NullPointerException {
        this.maxOperand = maxOperand;
        this.position = null;
    }

    public final boolean isNotBetween() {
        return this.notBetween;
    }

    public void setNotBetween(boolean notBetween) {
        this.notBetween = notBetween;
        this.position = null;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public ADQLObject getCopy() throws Exception {
        return new Between(this);
    }

    public String getName() {
        return (this.isNotBetween() ? "NOT " : "") + "BETWEEN";
    }

    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;

            public ADQLObject next() {
                switch (++this.index) {
                    case 0: {
                        return Between.this.leftOperand;
                    }
                    case 1: {
                        return Between.this.minOperand;
                    }
                    case 2: {
                        return Between.this.maxOperand;
                    }
                }
                throw new NoSuchElementException();
            }

            public boolean hasNext() {
                return this.index + 1 < 3;
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLOperand) {
                    switch (this.index) {
                        case 0: {
                            Between.this.leftOperand = (ADQLOperand)replacer;
                            break;
                        }
                        case 1: {
                            Between.this.minOperand = (ADQLOperand)replacer;
                            break;
                        }
                        case 2: {
                            Between.this.maxOperand = (ADQLOperand)replacer;
                        }
                    }
                    Between.this.position = null;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLOperand by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                }
            }

            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove this operand from the BETWEEN constraint !");
            }
        };
    }

    public String toADQL() {
        return this.leftOperand.toADQL() + " " + this.getName() + " " + this.minOperand.toADQL() + " AND " + this.maxOperand.toADQL();
    }
}

