/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import adql.query.constraint.ComparisonOperator;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class Comparison
implements ADQLConstraint {
    private ADQLOperand leftOperand;
    private ComparisonOperator compOperator;
    private ADQLOperand rightOperand;
    private TextPosition position = null;

    public Comparison(ADQLOperand left, ComparisonOperator comp, ADQLOperand right) throws NullPointerException, UnsupportedOperationException {
        this.setLeftOperand(left);
        this.setRightOperand(right);
        this.setOperation(comp);
    }

    public Comparison(Comparison toCopy) throws Exception {
        this.leftOperand = (ADQLOperand)toCopy.leftOperand.getCopy();
        this.compOperator = toCopy.compOperator;
        this.rightOperand = (ADQLOperand)toCopy.rightOperand.getCopy();
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    public final ADQLOperand getLeftOperand() {
        return this.leftOperand;
    }

    public void setLeftOperand(ADQLOperand newLeftOperand) throws NullPointerException, UnsupportedOperationException {
        if (newLeftOperand == null) {
            throw new NullPointerException("Impossible to update the left operand of the comparison (" + this.toADQL() + ") with a NULL operand !");
        }
        if (this.rightOperand != null && newLeftOperand.isNumeric() != this.rightOperand.isNumeric() && newLeftOperand.isString() != this.rightOperand.isString()) {
            throw new UnsupportedOperationException("Impossible to update the left operand of the comparison (" + this.toADQL() + ") with \"" + newLeftOperand.toADQL() + "\" because its type is not compatible with the type of the right operand !");
        }
        if (this.compOperator != null && newLeftOperand.isNumeric() && (this.compOperator == ComparisonOperator.LIKE || this.compOperator == ComparisonOperator.NOTLIKE)) {
            throw new UnsupportedOperationException("Impossible to update the left operand of the comparison (" + this.toADQL() + ") with \"" + newLeftOperand.toADQL() + "\" because the comparison operator " + this.compOperator.toADQL() + " is not applicable on numeric operands !");
        }
        this.leftOperand = newLeftOperand;
        this.position = null;
    }

    public ComparisonOperator getOperator() {
        return this.compOperator;
    }

    public void setOperation(ComparisonOperator newOperation) throws NullPointerException, UnsupportedOperationException {
        if (newOperation == null) {
            throw new NullPointerException("Impossible to update the comparison operator (" + this.compOperator.toADQL() + ") with a NULL operand !");
        }
        if (!(this.leftOperand.isString() && this.rightOperand.isString() || newOperation != ComparisonOperator.LIKE && newOperation != ComparisonOperator.NOTLIKE)) {
            throw new UnsupportedOperationException("Impossible to update the comparison operator" + (this.compOperator != null ? " (" + this.compOperator.toADQL() + ")" : "") + " by " + newOperation.toADQL() + " because the two operands (\"" + this.leftOperand.toADQL() + "\" & \"" + this.rightOperand.toADQL() + "\") are not all Strings !");
        }
        this.compOperator = newOperation;
        this.position = null;
    }

    public ADQLOperand getRightOperand() {
        return this.rightOperand;
    }

    public void setRightOperand(ADQLOperand newRightOperand) throws NullPointerException, UnsupportedOperationException {
        if (newRightOperand == null) {
            throw new NullPointerException("Impossible to update the right operand of the comparison (" + this.toADQL() + ") with a NULL operand !");
        }
        if (this.leftOperand != null && newRightOperand.isNumeric() != this.leftOperand.isNumeric() && newRightOperand.isString() != this.leftOperand.isString()) {
            throw new UnsupportedOperationException("Impossible to update the right operand of the comparison (" + this.toADQL() + ") with \"" + newRightOperand.toADQL() + "\" because its type is not compatible with the type of the left operand !");
        }
        if (this.compOperator != null && newRightOperand.isNumeric() && (this.compOperator == ComparisonOperator.LIKE || this.compOperator == ComparisonOperator.NOTLIKE)) {
            throw new UnsupportedOperationException("Impossible to update the right operand of the comparison (" + this.toADQL() + ") with \"" + newRightOperand.toADQL() + "\" because the comparison operator " + this.compOperator.toADQL() + " is not applicable on numeric operands !");
        }
        this.rightOperand = newRightOperand;
        this.position = null;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public ADQLObject getCopy() throws Exception {
        return new Comparison(this);
    }

    public String getName() {
        return this.compOperator.toADQL();
    }

    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;

            public ADQLObject next() {
                ++this.index;
                if (this.index == 0) {
                    return Comparison.this.leftOperand;
                }
                if (this.index == 1) {
                    return Comparison.this.rightOperand;
                }
                throw new NoSuchElementException();
            }

            public boolean hasNext() {
                return this.index + 1 < 2;
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLOperand) {
                    if (this.index == 0) {
                        Comparison.this.leftOperand = (ADQLOperand)replacer;
                        Comparison.this.position = null;
                    } else if (this.index == 1) {
                        Comparison.this.rightOperand = (ADQLOperand)replacer;
                        Comparison.this.position = null;
                    }
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLOperand by a " + replacer.getClass().getName() + " in a comparison !");
                }
            }

            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove an operand from a comparison !");
            }
        };
    }

    public String toADQL() {
        return (this.leftOperand == null ? "NULL" : this.leftOperand.toADQL()) + " " + (this.compOperator == null ? "NULL" : this.compOperator.toADQL()) + " " + (this.rightOperand == null ? "NULL" : this.rightOperand.toADQL());
    }
}

