/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ComparisonOperator {
    EQUAL,
    NOT_EQUAL,
    LESS_THAN,
    LESS_OR_EQUAL,
    GREATER_THAN,
    GREATER_OR_EQUAL,
    LIKE,
    NOTLIKE;


    public static ComparisonOperator getOperator(String str) throws UnsupportedOperationException {
        if (str.equalsIgnoreCase("=")) {
            return EQUAL;
        }
        if (str.equalsIgnoreCase("!=") || str.equalsIgnoreCase("<>")) {
            return NOT_EQUAL;
        }
        if (str.equalsIgnoreCase("<")) {
            return LESS_THAN;
        }
        if (str.equalsIgnoreCase("<=")) {
            return LESS_OR_EQUAL;
        }
        if (str.equalsIgnoreCase(">")) {
            return GREATER_THAN;
        }
        if (str.equalsIgnoreCase(">=")) {
            return GREATER_OR_EQUAL;
        }
        if (str.equalsIgnoreCase("LIKE")) {
            return LIKE;
        }
        if (str.equalsIgnoreCase("NOT LIKE")) {
            return NOTLIKE;
        }
        throw new UnsupportedOperationException("Comparison operator unknown: \"" + str + "\" !");
    }

    public String toADQL() {
        switch (this) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case LIKE: {
                return "LIKE";
            }
            case NOTLIKE: {
                return "NOT LIKE";
            }
        }
        return "???";
    }

    public String toString() {
        return this.toADQL();
    }
}

