/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLQuery;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import java.util.NoSuchElementException;

public class Exists
implements ADQLConstraint {
    private ADQLQuery subQuery;
    private TextPosition position = null;

    public Exists(ADQLQuery query) {
        this.subQuery = query;
    }

    public Exists(Exists toCopy) throws Exception {
        this.subQuery = (ADQLQuery)toCopy.subQuery.getCopy();
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    public final ADQLQuery getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(ADQLQuery query) throws NullPointerException {
        if (query == null) {
            throw new NullPointerException("Impossible to build an EXISTS constraint with a sub-query NULL !");
        }
        this.subQuery = query;
        this.position = null;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public ADQLObject getCopy() throws Exception {
        return new Exists(this);
    }

    public String getName() {
        return "EXISTS";
    }

    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean subQueryGot;
            {
                this.subQueryGot = Exists.this.subQuery == null;
            }

            public ADQLObject next() {
                if (this.subQueryGot) {
                    throw new NoSuchElementException();
                }
                this.subQueryGot = true;
                return Exists.this.subQuery;
            }

            public boolean hasNext() {
                return !this.subQueryGot;
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLQuery) {
                    Exists.this.subQuery = (ADQLQuery)replacer;
                    Exists.this.position = null;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLQuery by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                }
            }

            public void remove() {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the sub-query of an EXISTS constraint !");
            }
        };
    }

    public String toADQL() {
        return this.getName() + "(" + this.subQuery.toADQL() + ")";
    }
}

