/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import java.util.NoSuchElementException;

public class NotConstraint
implements ADQLConstraint {
    private ADQLConstraint constraint;
    private TextPosition position = null;

    public NotConstraint(ADQLConstraint constraint) throws NullPointerException {
        if (constraint == null) {
            throw new NullPointerException("Impossible to apply the logical operator NOT on a NULL constraint !");
        }
        this.constraint = constraint;
    }

    public final ADQLConstraint getConstraint() {
        return this.constraint;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public ADQLObject getCopy() throws Exception {
        return new NotConstraint((ADQLConstraint)this.constraint.getCopy());
    }

    public String getName() {
        return "NOT " + this.constraint.getName();
    }

    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean constraintGot;
            {
                this.constraintGot = NotConstraint.this.constraint == null;
            }

            public ADQLObject next() {
                if (this.constraintGot) {
                    throw new NoSuchElementException();
                }
                this.constraintGot = true;
                return NotConstraint.this.constraint;
            }

            public boolean hasNext() {
                return !this.constraintGot;
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.constraintGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLConstraint) {
                    NotConstraint.this.constraint = (ADQLConstraint)replacer;
                    NotConstraint.this.position = null;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLConstraint by a " + replacer.getClass().getName() + " !");
                }
            }

            public void remove() {
                if (!this.constraintGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the constraint of a NOT predicated !");
            }
        };
    }

    public String toADQL() {
        return "NOT " + this.constraint.toADQL();
    }
}

