/*
 * Decompiled with CFR 0.152.
 */
package adql.query.from;

import adql.db.DBColumn;
import adql.db.DBCommonColumn;
import adql.db.SearchColumnList;
import adql.db.exception.UnresolvedJoinException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ClauseConstraints;
import adql.query.IdentifierField;
import adql.query.TextPosition;
import adql.query.from.ADQLTable;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ADQLJoin
implements ADQLObject,
FromContent {
    private FromContent leftTable;
    private FromContent rightTable;
    protected boolean natural = false;
    protected ClauseConstraints condition = null;
    protected ArrayList<ADQLColumn> lstColumns = null;
    private TextPosition position = null;

    public ADQLJoin(FromContent left, FromContent right) {
        this.leftTable = left;
        this.rightTable = right;
    }

    public ADQLJoin(ADQLJoin toCopy) throws Exception {
        this.leftTable = (FromContent)toCopy.leftTable.getCopy();
        this.rightTable = (FromContent)toCopy.rightTable.getCopy();
        this.natural = toCopy.natural;
        this.condition = (ClauseConstraints)toCopy.condition.getCopy();
        if (toCopy.lstColumns != null) {
            this.lstColumns = new ArrayList(toCopy.lstColumns.size());
            for (ADQLColumn col : toCopy.lstColumns) {
                this.lstColumns.add((ADQLColumn)col.getCopy());
            }
        }
        this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
    }

    public final boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
        if (natural) {
            this.condition = null;
            this.lstColumns = null;
        }
        this.position = null;
    }

    public final FromContent getLeftTable() {
        return this.leftTable;
    }

    public void setLeftTable(FromContent table) {
        this.leftTable = table;
        this.position = null;
    }

    public final FromContent getRightTable() {
        return this.rightTable;
    }

    public void setRightTable(FromContent table) {
        this.rightTable = table;
        this.position = null;
    }

    public final ClauseConstraints getJoinCondition() {
        return this.condition;
    }

    public void setJoinCondition(ClauseConstraints cond) {
        this.condition = cond;
        if (this.condition != null) {
            this.natural = false;
            this.lstColumns = null;
        }
        this.position = null;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    @Override
    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public final Iterator<ADQLColumn> getJoinedColumns() {
        if (this.lstColumns == null) {
            return new Iterator<ADQLColumn>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ADQLColumn next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.lstColumns.iterator();
    }

    public final boolean hasJoinedColumns() {
        return this.lstColumns != null;
    }

    public void setJoinedColumns(Collection<ADQLColumn> columns) {
        if (columns != null && !columns.isEmpty()) {
            if (this.lstColumns == null) {
                this.lstColumns = new ArrayList(columns.size());
            } else {
                this.lstColumns.clear();
            }
            this.lstColumns.addAll(columns);
            this.natural = false;
            this.condition = null;
            this.position = null;
        }
    }

    @Override
    public String getName() {
        return this.getJoinType();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;
            private final int nbItems;
            private final int offset;
            private Iterator<ADQLColumn> itCol;
            {
                this.nbItems = 2 + (ADQLJoin.this.condition == null ? 0 : 1) + (ADQLJoin.this.lstColumns == null ? 0 : ADQLJoin.this.lstColumns.size());
                this.offset = 2 + (ADQLJoin.this.condition == null ? 0 : 1);
                this.itCol = null;
            }

            public ADQLObject next() {
                ++this.index;
                if (this.index == 0) {
                    return ADQLJoin.this.leftTable;
                }
                if (this.index == 1) {
                    return ADQLJoin.this.rightTable;
                }
                if (this.index == 2 && ADQLJoin.this.condition != null) {
                    return ADQLJoin.this.condition;
                }
                if (ADQLJoin.this.lstColumns != null && !ADQLJoin.this.lstColumns.isEmpty()) {
                    if (this.itCol == null) {
                        this.itCol = ADQLJoin.this.lstColumns.iterator();
                    }
                    return this.itCol.next();
                }
                throw new NoSuchElementException();
            }

            public boolean hasNext() {
                return this.itCol != null && this.itCol.hasNext() || this.index + 1 < this.nbItems;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (replacer == null) {
                    this.remove();
                } else if (this.index == 0) {
                    if (!(replacer instanceof FromContent)) throw new UnsupportedOperationException("Impossible to replace the left \"table\" of the join (" + ADQLJoin.this.leftTable.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") ! The replacer must be a FromContent instance.");
                    ADQLJoin.this.leftTable = (FromContent)replacer;
                } else if (this.index == 1) {
                    if (!(replacer instanceof FromContent)) throw new UnsupportedOperationException("Impossible to replace the right \"table\" of the join (" + ADQLJoin.this.rightTable.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") ! The replacer must be a FromContent instance.");
                    ADQLJoin.this.rightTable = (FromContent)replacer;
                } else if (this.index == 2 && this.itCol == null) {
                    if (!(replacer instanceof ClauseConstraints)) throw new UnsupportedOperationException("Impossible to replace an ADQLConstraint (" + ADQLJoin.this.condition + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                    ADQLJoin.this.condition = (ClauseConstraints)replacer;
                } else if (this.itCol != null) {
                    if (!(replacer instanceof ADQLColumn)) throw new UnsupportedOperationException("Impossible to replace an ADQLColumn by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
                    ADQLJoin.this.lstColumns.set(this.index - this.offset, (ADQLColumn)replacer);
                }
                ADQLJoin.this.position = null;
            }

            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                if (this.index == 0) {
                    throw new UnsupportedOperationException("Impossible to remove the left \"table\" of the join (" + ADQLJoin.this.leftTable.toADQL() + ") !");
                }
                if (this.index == 1) {
                    throw new UnsupportedOperationException("Impossible to remove the right \"table\" of the join (" + ADQLJoin.this.rightTable.toADQL() + ") !");
                }
                if (this.index == 2 && this.itCol == null) {
                    throw new UnsupportedOperationException("Impossible to remove a condition (" + ADQLJoin.this.condition.toADQL() + ") from a join (" + ADQLJoin.this.toADQL() + ") !");
                }
                if (this.itCol != null) {
                    this.itCol.remove();
                    --this.index;
                    ADQLJoin.this.position = null;
                }
            }
        };
    }

    @Override
    public String toADQL() {
        StringBuffer adql = new StringBuffer(this.leftTable.toADQL());
        adql.append(this.natural ? " NATURAL " : " ").append(this.getJoinType()).append(' ').append(this.rightTable.toADQL());
        if (this.condition != null) {
            adql.append(" ON ").append(this.condition.toADQL());
        } else if (this.lstColumns != null) {
            String cols = null;
            for (ADQLColumn item : this.lstColumns) {
                cols = cols == null ? "\"" + item.toADQL() + "\"" : cols + ", \"" + item.toADQL() + "\"";
            }
            adql.append(" USING (").append(cols).append(')');
        }
        return adql.toString();
    }

    @Override
    public SearchColumnList getDBColumns() throws UnresolvedJoinException {
        try {
            SearchColumnList list = new SearchColumnList();
            SearchColumnList leftList = this.leftTable.getDBColumns();
            SearchColumnList rightList = this.rightTable.getDBColumns();
            HashMap<String, DBCommonColumn> mapDuplicated = new HashMap<String, DBCommonColumn>();
            if (this.natural) {
                for (DBColumn leftCol : leftList) {
                    DBColumn rightCol = ADQLJoin.findAtMostOneColumn(leftCol.getADQLName(), (byte)0, rightList, false);
                    if (rightCol == null) continue;
                    ADQLJoin.findExactlyOneColumn(leftCol.getADQLName(), (byte)0, leftList, true);
                    mapDuplicated.put(leftCol.getADQLName().toLowerCase(), new DBCommonColumn(leftCol, rightCol));
                }
            } else if (this.lstColumns != null && !this.lstColumns.isEmpty()) {
                for (ADQLColumn usingCol : this.lstColumns) {
                    DBColumn leftCol = ADQLJoin.findExactlyOneColumn(usingCol.getColumnName(), usingCol.getCaseSensitive(), leftList, true);
                    DBColumn rightCol = ADQLJoin.findExactlyOneColumn(usingCol.getColumnName(), usingCol.getCaseSensitive(), rightList, false);
                    mapDuplicated.put(usingCol.isCaseSensitive(IdentifierField.COLUMN) ? "\"" + usingCol.getColumnName() + "\"" : usingCol.getColumnName().toLowerCase(), new DBCommonColumn(leftCol, rightCol));
                }
            } else {
                list.addAll(leftList);
                list.addAll(rightList);
                return list;
            }
            ADQLJoin.addAllExcept(leftList, list, mapDuplicated);
            ADQLJoin.addAllExcept(rightList, list, mapDuplicated);
            list.addAll((Collection<? extends DBColumn>)mapDuplicated.values());
            return list;
        }
        catch (UnresolvedJoinException uje) {
            uje.setPosition(this.position);
            throw uje;
        }
    }

    public static final void addAllExcept(SearchColumnList itemsToAdd, SearchColumnList target, Map<String, DBCommonColumn> exception) {
        for (DBColumn col : itemsToAdd) {
            if (exception.containsKey(col.getADQLName().toLowerCase()) || exception.containsKey("\"" + col.getADQLName() + "\"")) continue;
            target.add(col);
        }
    }

    public static final DBColumn findExactlyOneColumn(String columnName, byte caseSensitive, SearchColumnList list, boolean leftList) throws UnresolvedJoinException {
        DBColumn result = ADQLJoin.findAtMostOneColumn(columnName, caseSensitive, list, leftList);
        if (result == null) {
            throw new UnresolvedJoinException("Column \"" + columnName + "\" specified in USING clause does not exist in " + (leftList ? "left" : "right") + " table!");
        }
        return result;
    }

    public static final DBColumn findAtMostOneColumn(String columnName, byte caseSensitive, SearchColumnList list, boolean leftList) throws UnresolvedJoinException {
        ArrayList<DBColumn> result = list.search(null, null, null, columnName, caseSensitive);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new UnresolvedJoinException("Common column name \"" + columnName + "\" appears more than once in " + (leftList ? "left" : "right") + " table!");
        }
        return result.get(0);
    }

    public static final boolean isCommonColumn(DBColumn col) {
        return col != null && col instanceof DBCommonColumn;
    }

    @Override
    public ArrayList<ADQLTable> getTables() {
        ArrayList<ADQLTable> tables = this.leftTable.getTables();
        tables.addAll(this.rightTable.getTables());
        return tables;
    }

    @Override
    public ArrayList<ADQLTable> getTablesByAlias(String alias, boolean caseSensitive) {
        ArrayList<ADQLTable> tables = this.leftTable.getTablesByAlias(alias, caseSensitive);
        tables.addAll(this.rightTable.getTablesByAlias(alias, caseSensitive));
        return tables;
    }

    public abstract String getJoinType();

    @Override
    public abstract ADQLObject getCopy() throws Exception;
}

