/*
 * Decompiled with CFR 0.152.
 */
package adql.query.from;

import adql.query.ADQLObject;
import adql.query.ClauseConstraints;
import adql.query.from.ADQLJoin;
import adql.query.from.FromContent;
import adql.query.operand.ADQLColumn;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OuterJoin
extends ADQLJoin {
    private OuterType type = OuterType.LEFT;

    public OuterJoin(FromContent left, FromContent right, OuterType type) {
        super(left, right);
        this.setNatural(true);
        this.setType(type);
    }

    public OuterJoin(FromContent left, FromContent right, OuterType type, ClauseConstraints condition) {
        super(left, right);
        this.setJoinCondition(condition);
        this.setType(type);
    }

    public OuterJoin(FromContent left, FromContent right, OuterType type, Collection<ADQLColumn> lstColumns) {
        super(left, right);
        this.setJoinedColumns(new ArrayList<ADQLColumn>(lstColumns));
        this.setType(type);
    }

    public OuterJoin(OuterJoin toCopy) throws Exception {
        super(toCopy);
        this.setType(toCopy.type);
    }

    @Override
    public String getJoinType() {
        return this.type.toString() + " OUTER JOIN";
    }

    public final OuterType getType() {
        return this.type;
    }

    public void setType(OuterType type) {
        if (type != null) {
            this.type = type;
        }
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new OuterJoin(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OuterType {
        LEFT,
        RIGHT,
        FULL;

    }
}

