/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public final class NegativeOperand
implements ADQLOperand {
    private ADQLOperand operand;
    private TextPosition position = null;

    public NegativeOperand(ADQLOperand operand) throws NullPointerException, UnsupportedOperationException {
        if (operand == null) {
            throw new NullPointerException("Impossible to negativate an operand equals to NULL !");
        }
        if (!operand.isNumeric()) {
            throw new UnsupportedOperationException("Impossible to negativate a non-numeric operand (" + operand.toADQL() + ") !");
        }
        this.operand = operand;
    }

    public final ADQLOperand getOperand() {
        return this.operand;
    }

    public final boolean isNumeric() {
        return true;
    }

    public final boolean isString() {
        return false;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public final boolean isGeometry() {
        return false;
    }

    public ADQLObject getCopy() throws Exception {
        NegativeOperand copy = new NegativeOperand((ADQLOperand)this.operand.getCopy());
        return copy;
    }

    public String getName() {
        return "-" + this.operand.getName();
    }

    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean operandGot;
            {
                this.operandGot = NegativeOperand.this.operand == null;
            }

            public ADQLObject next() {
                if (this.operandGot) {
                    throw new NoSuchElementException();
                }
                this.operandGot = true;
                return NegativeOperand.this.operand;
            }

            public boolean hasNext() {
                return !this.operandGot;
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.operandGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLOperand && ((ADQLOperand)replacer).isNumeric()) {
                    NegativeOperand.this.operand = (ADQLOperand)replacer;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace the operand \"" + NegativeOperand.this.operand.toADQL() + "\" by \"" + replacer.toADQL() + "\" in the NegativeOperand \"" + NegativeOperand.this.toADQL() + "\" because the replacer is not an ADQLOperand or is not numeric !");
                }
            }

            public void remove() {
                if (!this.operandGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the only operand (" + NegativeOperand.this.operand.toADQL() + ") of a NegativeOperand (" + NegativeOperand.this.toADQL() + "). However you can remove the whole NegativeOperand.");
            }
        };
    }

    public String toADQL() {
        return "-" + this.operand.toADQL();
    }
}

