/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;

public final class NumericConstant
implements ADQLOperand {
    private String value;
    private TextPosition position = null;

    public NumericConstant(String value) throws NumberFormatException {
        this(value, true);
    }

    public NumericConstant(long val) {
        this("" + val, false);
    }

    public NumericConstant(double val) {
        this("" + val, false);
    }

    public NumericConstant(String value, boolean checkNumeric) throws NumberFormatException {
        this.setValue(value, checkNumeric);
    }

    public NumericConstant(NumericConstant toCopy) {
        this.value = toCopy.value;
    }

    public final String getValue() {
        return this.value;
    }

    public final double getNumericValue() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public final void setValue(long value) {
        this.value = "" + value;
    }

    public final void setValue(double value) {
        this.value = "" + value;
    }

    public final void setValue(String value) throws NumberFormatException {
        this.setValue(value, true);
    }

    public final void setValue(String value, boolean checkNumeric) throws NumberFormatException {
        if (checkNumeric) {
            Double.parseDouble(value);
        }
        this.value = value;
    }

    public final boolean isNumeric() {
        return true;
    }

    public final boolean isString() {
        return false;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public final boolean isGeometry() {
        return false;
    }

    public ADQLObject getCopy() {
        return new NumericConstant(this);
    }

    public String getName() {
        return this.value;
    }

    public ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    public String toADQL() {
        return this.value;
    }
}

