/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperationType {
    SUM,
    SUB,
    MULT,
    DIV;


    public static String[] getOperators() {
        return new String[]{SUM.toString(), SUB.toString(), MULT.toString(), DIV.toString()};
    }

    public static OperationType getOperator(String str) throws UnsupportedOperationException {
        if (str.equalsIgnoreCase("+")) {
            return SUM;
        }
        if (str.equalsIgnoreCase("-")) {
            return SUB;
        }
        if (str.equalsIgnoreCase("*")) {
            return MULT;
        }
        if (str.equalsIgnoreCase("/")) {
            return DIV;
        }
        throw new UnsupportedOperationException("Numeric operation unknown: \"" + str + "\" !");
    }

    public String toADQL() {
        return this.toString();
    }

    public String toString() {
        switch (this) {
            case SUM: {
                return "+";
            }
            case SUB: {
                return "-";
            }
            case MULT: {
                return "*";
            }
            case DIV: {
                return "/";
            }
        }
        return "???";
    }
}

