/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;

public final class StringConstant
implements ADQLOperand {
    private String value;
    private TextPosition position = null;

    public StringConstant(String value) {
        this.value = value;
    }

    public StringConstant(StringConstant toCopy) {
        this.value = toCopy.value;
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public final boolean isNumeric() {
        return false;
    }

    public final boolean isString() {
        return true;
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public final boolean isGeometry() {
        return false;
    }

    public ADQLObject getCopy() {
        return new StringConstant(this);
    }

    public String getName() {
        return this.toADQL();
    }

    public ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    public String toADQL() {
        return "'" + this.value.replaceAll("'", "''") + "'";
    }
}

