/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ADQLFunction
implements ADQLOperand {
    private TextPosition position = null;

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    public abstract int getNbParameters();

    public abstract ADQLOperand[] getParameters();

    public abstract ADQLOperand getParameter(int var1) throws ArrayIndexOutOfBoundsException;

    public abstract ADQLOperand setParameter(int var1, ADQLOperand var2) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception;

    public Iterator<ADQLOperand> paramIterator() {
        return new ParameterIterator(this);
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private int index = -1;

            public ADQLObject next() {
                try {
                    return ADQLFunction.this.getParameter(++this.index);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new NoSuchElementException();
                }
            }

            public boolean hasNext() {
                return this.index + 1 < ADQLFunction.this.getNbParameters();
            }

            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (this.index <= -1) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLOperand) {
                    try {
                        ADQLFunction.this.setParameter(this.index, (ADQLOperand)replacer);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new UnsupportedOperationException(e);
                    }
                } else {
                    throw new UnsupportedOperationException("Impossible to replace the " + this.index + "-th parameter of \"" + ADQLFunction.this.toADQL() + "\" by an object whose the class (" + replacer.getClass().getName() + ") is not ADQLOperand !");
                }
            }

            public void remove() {
                if (this.index <= -1) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove a parameter of an ADQL function (here the " + this.index + "-th parameter of \"" + ADQLFunction.this.toADQL() + "\")");
            }
        };
    }

    @Override
    public String toADQL() {
        String adql = this.getName() + "(";
        for (int i = 0; i < this.getNbParameters(); ++i) {
            adql = adql + (i == 0 ? "" : ", ") + this.getParameter(i).toADQL();
        }
        return adql + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ParameterIterator
    implements Iterator<ADQLOperand> {
        protected final ADQLFunction function;
        protected int index = -1;

        public ParameterIterator(ADQLFunction fct) throws NullPointerException {
            if (fct == null) {
                throw new NullPointerException("Impossible to build an iterator on a function without the function on which the iterator must be applied !");
            }
            this.function = fct;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.function.getNbParameters();
        }

        @Override
        public ADQLOperand next() {
            ++this.index;
            return this.function.getParameter(this.index);
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            try {
                this.function.setParameter(this.index, null);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }
}

