/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.db.FunctionDef;
import adql.query.ADQLList;
import adql.query.ADQLObject;
import adql.query.ClauseADQL;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.UserDefinedFunction;
import adql.translator.ADQLTranslator;
import adql.translator.TranslationException;

public final class DefaultUDF
extends UserDefinedFunction {
    protected FunctionDef definition = null;
    protected final ADQLList<ADQLOperand> parameters;
    protected final String functionName;

    public DefaultUDF(String name, ADQLOperand[] params) throws NullPointerException {
        this.functionName = name;
        this.parameters = new ClauseADQL<ADQLOperand>();
        if (params != null) {
            for (ADQLOperand p : params) {
                this.parameters.add(p);
            }
        }
    }

    public DefaultUDF(DefaultUDF toCopy) throws Exception {
        this.functionName = toCopy.functionName;
        this.parameters = (ADQLList)toCopy.parameters.getCopy();
        this.setPosition(toCopy.getPosition() == null ? null : new TextPosition(toCopy.getPosition()));
    }

    public final FunctionDef getDefinition() {
        return this.definition;
    }

    public final void setDefinition(FunctionDef def) throws IllegalArgumentException {
        if (!(def == null || def.name != null && this.functionName.equalsIgnoreCase(def.name))) {
            throw new IllegalArgumentException("The parsed function name (" + this.functionName + ") does not match to the name of the given UDF definition (" + def.name + ").");
        }
        this.definition = def;
    }

    public final boolean isNumeric() {
        return this.definition == null || this.definition.isNumeric();
    }

    public final boolean isString() {
        return this.definition == null || this.definition.isString();
    }

    public final boolean isGeometry() {
        return this.definition == null || this.definition.isGeometry();
    }

    public ADQLObject getCopy() throws Exception {
        DefaultUDF copy = new DefaultUDF(this);
        copy.setDefinition(this.definition);
        return copy;
    }

    public final String getName() {
        return this.functionName;
    }

    public final ADQLOperand[] getParameters() {
        ADQLOperand[] params = new ADQLOperand[this.parameters.size()];
        int i = 0;
        for (ADQLOperand op : this.parameters) {
            params[i++] = op;
        }
        return params;
    }

    public final int getNbParameters() {
        return this.parameters.size();
    }

    public final ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        return this.parameters.get(index);
    }

    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        ADQLOperand oldParam = this.parameters.set(index, replacer);
        this.setPosition(null);
        return oldParam;
    }

    public String translate(ADQLTranslator caller) throws TranslationException {
        StringBuffer sql = new StringBuffer(this.functionName);
        sql.append('(');
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i > 0) {
                sql.append(',').append(' ');
            }
            sql.append(caller.translate(this.parameters.get(i)));
        }
        sql.append(')');
        return sql.toString();
    }
}

