/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function;

import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.MathFunctionType;

public class MathFunction
extends ADQLFunction {
    private final MathFunctionType type;
    private ADQLOperand param1 = null;
    private ADQLOperand param2 = null;
    private int nbParams;

    public MathFunction(MathFunctionType t) throws Exception {
        this(t, null, null);
    }

    public MathFunction(MathFunctionType t, ADQLOperand parameter) throws Exception {
        this(t, parameter, null);
    }

    public MathFunction(MathFunctionType t, ADQLOperand parameter1, ADQLOperand parameter2) throws Exception {
        this.type = t;
        if (this.type.nbMaxParams() > 2) {
            throw new Exception("Impossible for MathFunction object to have " + this.type.nbMaxParams() + " ! It is limited to 2 parameters !");
        }
        this.nbParams = (parameter1 != null ? 1 : 0) + (parameter2 != null ? 1 : 0);
        if (this.nbParams < this.type.nbMinParams() || this.nbParams > this.type.nbMaxParams()) {
            if (this.type.nbMinParams() == this.type.nbMaxParams()) {
                throw new Exception("The function " + this.type.name() + " must have " + (this.type.nbMaxParams() == 0 ? "no parameter!" : "exactly " + this.type.nbMaxParams() + " parameters!"));
            }
            switch (this.type.nbMaxParams()) {
                case 0: {
                    throw new Exception("The function " + this.type.name() + " must have no parameter !");
                }
                case 1: {
                    throw new Exception("The function " + this.type.name() + " must have only one parameter !");
                }
                case 2: {
                    throw new Exception("The function " + this.type.name() + " must have two parameters !");
                }
            }
        }
        this.param1 = parameter1;
        this.param2 = parameter2;
    }

    public MathFunction(MathFunction toCopy) throws Exception {
        this.type = toCopy.type;
        this.param1 = (ADQLOperand)toCopy.param1.getCopy();
        this.param2 = (ADQLOperand)toCopy.param2.getCopy();
        this.setPosition(toCopy.getPosition() == null ? null : new TextPosition(toCopy.getPosition()));
    }

    public final MathFunctionType getType() {
        return this.type;
    }

    public ADQLObject getCopy() throws Exception {
        return new MathFunction(this);
    }

    public String getName() {
        return this.type.name();
    }

    public final boolean isNumeric() {
        return true;
    }

    public final boolean isString() {
        return false;
    }

    public final boolean isGeometry() {
        return false;
    }

    public ADQLOperand[] getParameters() {
        switch (this.getNbParameters()) {
            case 1: {
                return new ADQLOperand[]{this.param1};
            }
            case 2: {
                return new ADQLOperand[]{this.param1, this.param2};
            }
        }
        return new ADQLOperand[0];
    }

    public int getNbParameters() {
        return this.nbParams;
    }

    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.type.name() + "\" (nb required params = " + this.type.nbMaxParams() + ") !");
        }
        switch (index) {
            case 0: {
                return this.param1;
            }
            case 1: {
                return this.param2;
            }
        }
        return null;
    }

    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index < 0 || index >= this.getNbParameters()) {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.type.name() + "\" (nb required params = " + this.type.nbMaxParams() + ") !");
        }
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove any parameter from a mathematical function ! All parameters are required !");
        }
        ADQLOperand replaced = null;
        switch (index) {
            case 0: {
                replaced = this.param1;
                this.param1 = replacer;
                this.setPosition(null);
                break;
            }
            case 1: {
                replaced = this.param2;
                this.param2 = replacer;
                this.setPosition(null);
            }
        }
        return replaced;
    }
}

