/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class BoxFunction
extends GeometryFunction {
    private ADQLOperand coord1;
    private ADQLOperand coord2;
    private ADQLOperand width;
    private ADQLOperand height;

    public BoxFunction(ADQLOperand coordinateSystem, ADQLOperand firstCoord, ADQLOperand secondCoord, ADQLOperand boxWidth, ADQLOperand boxHeight) throws NullPointerException, Exception {
        super(coordinateSystem);
        if (firstCoord == null || secondCoord == null || boxWidth == null || boxHeight == null) {
            throw new NullPointerException("All the parameters of the BOX function must be different from NULL !");
        }
        this.coord1 = firstCoord;
        this.coord2 = secondCoord;
        this.width = boxWidth;
        this.height = boxHeight;
    }

    public BoxFunction(BoxFunction toCopy) throws Exception {
        super(toCopy);
        this.coord1 = (ADQLOperand)toCopy.coord1.getCopy();
        this.coord2 = (ADQLOperand)toCopy.coord2.getCopy();
        this.width = (ADQLOperand)toCopy.width.getCopy();
        this.height = (ADQLOperand)toCopy.height.getCopy();
    }

    public ADQLObject getCopy() throws Exception {
        return new BoxFunction(this);
    }

    public String getName() {
        return "BOX";
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isGeometry() {
        return true;
    }

    public final ADQLOperand getCoord1() {
        return this.coord1;
    }

    public final void setCoord1(ADQLOperand coord1) {
        this.coord1 = coord1;
        this.setPosition(null);
    }

    public final ADQLOperand getCoord2() {
        return this.coord2;
    }

    public final void setCoord2(ADQLOperand coord2) {
        this.coord2 = coord2;
        this.setPosition(null);
    }

    public final ADQLOperand getWidth() {
        return this.width;
    }

    public final void setWidth(ADQLOperand width) {
        this.width = width;
        this.setPosition(null);
    }

    public final ADQLOperand getHeight() {
        return this.height;
    }

    public final void setHeight(ADQLOperand height) {
        this.height = height;
        this.setPosition(null);
    }

    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.coordSys, this.coord1, this.coord2, this.width, this.height};
    }

    public int getNbParameters() {
        return 5;
    }

    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.coordSys;
            }
            case 1: {
                return this.coord1;
            }
            case 2: {
                return this.coord2;
            }
            case 3: {
                return this.width;
            }
            case 4: {
                return this.height;
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove one parameter from a " + this.getName() + " function !");
        }
        if (!(replacer instanceof ADQLOperand)) {
            throw new Exception("Impossible to replace an ADQLOperand by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
        }
        ADQLOperand replaced = null;
        switch (index) {
            case 0: {
                replaced = this.coordSys;
                this.setCoordinateSystem(replacer);
                break;
            }
            case 1: {
                replaced = this.coord1;
                this.coord1 = replacer;
                break;
            }
            case 2: {
                replaced = this.coord2;
                this.coord2 = replacer;
                break;
            }
            case 3: {
                replaced = this.width;
                this.width = replacer;
                break;
            }
            case 4: {
                replaced = this.height;
                this.height = replacer;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
            }
        }
        this.setPosition(null);
        return replaced;
    }
}

