/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class CircleFunction
extends GeometryFunction {
    private ADQLOperand coord1;
    private ADQLOperand coord2;
    private ADQLOperand radius;

    public CircleFunction(ADQLOperand coordinateSystem, ADQLOperand firstCoord, ADQLOperand secondCoord, ADQLOperand radius) throws NullPointerException, Exception {
        super(coordinateSystem);
        if (firstCoord == null || secondCoord == null || radius == null) {
            throw new NullPointerException("All parameters of a CIRCLE function must be different from NULL !");
        }
        this.coord1 = firstCoord;
        this.coord2 = secondCoord;
        this.radius = radius;
    }

    public CircleFunction(CircleFunction toCopy) throws Exception {
        super(toCopy);
        this.coord1 = (ADQLOperand)toCopy.coord1.getCopy();
        this.coord2 = (ADQLOperand)toCopy.coord2.getCopy();
        this.radius = (ADQLOperand)toCopy.radius.getCopy();
    }

    public ADQLObject getCopy() throws Exception {
        return new CircleFunction(this);
    }

    public String getName() {
        return "CIRCLE";
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isGeometry() {
        return true;
    }

    public final ADQLOperand getCoord1() {
        return this.coord1;
    }

    public final void setCoord1(ADQLOperand coord1) {
        this.coord1 = coord1;
        this.setPosition(null);
    }

    public final ADQLOperand getCoord2() {
        return this.coord2;
    }

    public final void setCoord2(ADQLOperand coord2) {
        this.coord2 = coord2;
        this.setPosition(null);
    }

    public final ADQLOperand getRadius() {
        return this.radius;
    }

    public final void setRadius(ADQLOperand radius) {
        this.radius = radius;
        this.setPosition(null);
    }

    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.coordSys, this.coord1, this.coord2, this.radius};
    }

    public int getNbParameters() {
        return 4;
    }

    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.coordSys;
            }
            case 1: {
                return this.coord1;
            }
            case 2: {
                return this.coord2;
            }
            case 3: {
                return this.radius;
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove one parameter of a " + this.getName() + " function !");
        }
        ADQLOperand replaced = null;
        switch (index) {
            case 0: {
                replaced = this.coordSys;
                this.setCoordinateSystem(replacer);
                break;
            }
            case 1: {
                replaced = this.coord1;
                this.coord1 = replacer;
                break;
            }
            case 2: {
                replaced = this.coord2;
                this.coord2 = replacer;
                break;
            }
            case 3: {
                replaced = this.radius;
                this.radius = replacer;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
            }
        }
        this.setPosition(null);
        return replaced;
    }
}

