/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceFunction
extends GeometryFunction {
    private GeometryFunction.GeometryValue<PointFunction> p1;
    private GeometryFunction.GeometryValue<PointFunction> p2;

    public DistanceFunction(GeometryFunction.GeometryValue<PointFunction> point1, GeometryFunction.GeometryValue<PointFunction> point2) throws NullPointerException {
        if (point1 == null || point2 == null) {
            throw new NullPointerException("All parameters of the DISTANCE function must be different from null !");
        }
        this.p1 = point1;
        this.p2 = point2;
    }

    public DistanceFunction(DistanceFunction toCopy) throws Exception {
        super(toCopy);
        this.p1 = (GeometryFunction.GeometryValue)toCopy.p1.getCopy();
        this.p2 = (GeometryFunction.GeometryValue)toCopy.p2.getCopy();
    }

    @Override
    public void setCoordinateSystem(ADQLOperand coordSys) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("A DISTANCE function is not associated to a coordinate system !");
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new DistanceFunction(this);
    }

    @Override
    public String getName() {
        return "DISTANCE";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return false;
    }

    public final GeometryFunction.GeometryValue<PointFunction> getP1() {
        return this.p1;
    }

    public final void setP1(GeometryFunction.GeometryValue<PointFunction> p1) {
        this.p1 = p1;
        this.setPosition(null);
    }

    public final GeometryFunction.GeometryValue<PointFunction> getP2() {
        return this.p2;
    }

    public final void setP2(GeometryFunction.GeometryValue<PointFunction> p2) {
        this.p2 = p2;
        this.setPosition(null);
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.p1.getValue(), this.p2.getValue()};
    }

    @Override
    public int getNbParameters() {
        return 2;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.p1.getValue();
            }
            case 1: {
                return this.p2.getValue();
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove a parameter from the function " + this.getName() + " !");
        }
        if (!(replacer instanceof GeometryFunction.GeometryValue || replacer instanceof ADQLColumn || replacer instanceof PointFunction)) {
            throw new Exception("Impossible to replace a GeometryValue/Column/PointFunction by " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
        }
        ADQLOperand replaced = null;
        GeometryFunction.GeometryValue<PointFunction> toUpdate = null;
        switch (index) {
            case 0: {
                replaced = this.p1.getValue();
                if (replacer instanceof GeometryFunction.GeometryValue) {
                    this.p1 = (GeometryFunction.GeometryValue)replacer;
                    break;
                }
                toUpdate = this.p1;
                break;
            }
            case 1: {
                replaced = this.p2.getValue();
                if (replacer instanceof GeometryFunction.GeometryValue) {
                    this.p2 = (GeometryFunction.GeometryValue)replacer;
                    break;
                }
                toUpdate = this.p2;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
            }
        }
        if (toUpdate != null) {
            if (replacer instanceof ADQLColumn) {
                toUpdate.setColumn((ADQLColumn)replacer);
            } else if (replacer instanceof PointFunction) {
                toUpdate.setGeometry((PointFunction)replacer);
            }
        }
        this.setPosition(null);
        return replaced;
    }
}

