/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.ParseException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.StringConstant;
import adql.query.operand.function.ADQLFunction;

public abstract class GeometryFunction
extends ADQLFunction {
    protected ADQLOperand coordSys = null;

    protected GeometryFunction() {
        this.coordSys = null;
    }

    protected GeometryFunction(ADQLOperand coordSys) throws UnsupportedOperationException, NullPointerException, Exception {
        this.setCoordinateSystem(coordSys);
    }

    protected GeometryFunction(GeometryFunction toCopy) throws Exception {
        this.coordSys = (ADQLOperand)toCopy.coordSys.getCopy();
        this.setPosition(toCopy.getPosition() == null ? null : new TextPosition(toCopy.getPosition()));
    }

    public ADQLOperand getCoordinateSystem() {
        return this.coordSys;
    }

    public void setCoordinateSystem(ADQLOperand coordSys) throws UnsupportedOperationException, NullPointerException, ParseException {
        if (coordSys == null) {
            this.coordSys = new StringConstant("");
        } else {
            if (!coordSys.isString()) {
                throw new ParseException("A coordinate system must be a string literal: \"" + coordSys.toADQL() + "\" is not a string operand!");
            }
            this.coordSys = coordSys;
            this.setPosition(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GeometryValue<F extends GeometryFunction>
    implements ADQLOperand {
        private ADQLColumn column;
        private F geomFunct;
        private TextPosition position = null;

        public GeometryValue(ADQLColumn col) throws NullPointerException {
            if (col == null) {
                throw new NullPointerException("Impossible to build a GeometryValue without a column or a geometry function !");
            }
            this.setColumn(col);
            if (col.getPosition() != null) {
                this.position = col.getPosition();
            }
        }

        public GeometryValue(F geometry) throws NullPointerException {
            if (geometry == null) {
                throw new NullPointerException("Impossible to build a GeometryValue without a column or a geometry function !");
            }
            this.setGeometry(geometry);
            if (((ADQLFunction)geometry).getPosition() != null) {
                this.position = ((ADQLFunction)geometry).getPosition();
            }
        }

        public GeometryValue(GeometryValue<F> toCopy) throws Exception {
            this.column = toCopy.column == null ? null : (ADQLColumn)toCopy.column.getCopy();
            this.geomFunct = toCopy.geomFunct == null ? null : (GeometryFunction)toCopy.geomFunct.getCopy();
            this.position = toCopy.position == null ? null : new TextPosition(toCopy.position);
        }

        public void setColumn(ADQLColumn col) {
            if (col != null) {
                this.geomFunct = null;
                this.column = col;
                this.position = this.column.getPosition() != null ? this.column.getPosition() : null;
            }
        }

        public void setGeometry(F geometry) {
            if (geometry != null) {
                this.column = null;
                this.geomFunct = geometry;
                this.position = ((ADQLFunction)this.geomFunct).getPosition() != null ? ((ADQLFunction)this.geomFunct).getPosition() : null;
            }
        }

        public ADQLOperand getValue() {
            return this.column != null ? this.column : this.geomFunct;
        }

        public boolean isColumn() {
            return this.column != null;
        }

        @Override
        public boolean isNumeric() {
            return this.getValue().isNumeric();
        }

        @Override
        public boolean isString() {
            return this.getValue().isString();
        }

        @Override
        public TextPosition getPosition() {
            return this.position;
        }

        @Override
        public boolean isGeometry() {
            return this.getValue().isGeometry();
        }

        @Override
        public ADQLObject getCopy() throws Exception {
            return new GeometryValue<F>(this);
        }

        @Override
        public String getName() {
            return this.getValue().getName();
        }

        @Override
        public ADQLIterator adqlIterator() {
            return this.getValue().adqlIterator();
        }

        @Override
        public String toADQL() {
            return this.getValue().toADQL();
        }
    }
}

