/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class PointFunction
extends GeometryFunction {
    private ADQLOperand coord1;
    private ADQLOperand coord2;

    public PointFunction(ADQLOperand coordinateSystem, ADQLOperand firstCoord, ADQLOperand secondCoord) throws UnsupportedOperationException, NullPointerException, Exception {
        super(coordinateSystem);
        if (firstCoord == null || secondCoord == null) {
            throw new NullPointerException("The POINT function must have non-null coordinates!");
        }
        this.coord1 = firstCoord;
        this.coord2 = secondCoord;
    }

    public PointFunction(PointFunction toCopy) throws Exception {
        super(toCopy);
        this.coord1 = (ADQLOperand)toCopy.coord1.getCopy();
        this.coord2 = (ADQLOperand)toCopy.coord2.getCopy();
    }

    public final ADQLOperand getCoord1() {
        return this.coord1;
    }

    public void setCoord1(ADQLOperand coord1) throws NullPointerException, Exception {
        if (coord1 == null) {
            throw new NullPointerException("The first coordinate of a POINT function must be different from NULL !");
        }
        if (!coord1.isNumeric()) {
            throw new Exception("Coordinates of a POINT function must be numeric !");
        }
        this.coord1 = coord1;
        this.setPosition(null);
    }

    public final ADQLOperand getCoord2() {
        return this.coord2;
    }

    public void setCoord2(ADQLOperand coord2) throws NullPointerException, Exception {
        if (coord2 == null) {
            throw new NullPointerException("The second coordinate of a POINT function must be different from NULL !");
        }
        if (!coord2.isNumeric()) {
            throw new Exception("Coordinates of a POINT function must be numeric !");
        }
        this.coord2 = coord2;
        this.setPosition(null);
    }

    public ADQLObject getCopy() throws Exception {
        return new PointFunction(this);
    }

    public String getName() {
        return "POINT";
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isGeometry() {
        return true;
    }

    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.coordSys, this.coord1, this.coord2};
    }

    public int getNbParameters() {
        return 3;
    }

    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.getCoordinateSystem();
            }
            case 1: {
                return this.getCoord1();
            }
            case 2: {
                return this.getCoord2();
            }
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + " !");
    }

    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove a parameter from the function " + this.getName() + " !");
        }
        ADQLOperand replaced = null;
        switch (index) {
            case 0: {
                replaced = this.getCoordinateSystem();
                this.setCoordinateSystem(replacer);
                break;
            }
            case 1: {
                replaced = this.getCoord1();
                this.setCoord1(replacer);
                break;
            }
            case 2: {
                replaced = this.getCoord2();
                this.setCoord2(replacer);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
            }
        }
        this.setPosition(null);
        return replaced;
    }
}

