/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonFunction
extends GeometryFunction {
    protected Vector<ADQLOperand> coordinates;

    public PolygonFunction(ADQLOperand coordSystem, ADQLOperand[] coords) throws UnsupportedOperationException, NullPointerException, Exception {
        super(coordSystem);
        if (coords == null || coords.length < 6) {
            throw new NullPointerException("A POLYGON function must have at least 3 2-D coordinates !");
        }
        this.coordinates = new Vector(coords.length);
        for (int i = 0; i < coords.length; ++i) {
            this.coordinates.add(coords[i]);
        }
    }

    public PolygonFunction(ADQLOperand coordSystem, Collection<? extends ADQLOperand> coords) throws UnsupportedOperationException, NullPointerException, Exception {
        super(coordSystem);
        if (coords == null || coords.size() < 6) {
            throw new NullPointerException("A POLYGON function must have at least 3 2-D coordinates !");
        }
        this.coordinates = new Vector(coords.size());
        this.coordinates.addAll(coords);
    }

    public PolygonFunction(PolygonFunction toCopy) throws Exception {
        super(toCopy);
        this.coordinates = new Vector(toCopy.coordinates.size());
        for (ADQLOperand item : toCopy.coordinates) {
            this.coordinates.add((ADQLOperand)item.getCopy());
        }
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new PolygonFunction(this);
    }

    @Override
    public String getName() {
        return "POLYGON";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    @Override
    public ADQLOperand[] getParameters() {
        ADQLOperand[] params = new ADQLOperand[this.coordinates.size() + 1];
        params[0] = this.coordSys;
        for (int i = 0; i < this.coordinates.size(); ++i) {
            params[i + 1] = this.coordinates.get(i);
        }
        return params;
    }

    @Override
    public int getNbParameters() {
        return this.coordinates.size() + 1;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            return this.coordSys;
        }
        if (index >= 1 && index <= this.coordinates.size()) {
            return this.coordinates.get(index - 1);
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" (" + this.toADQL() + ") !");
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (replacer == null) {
            throw new NullPointerException("Impossible to remove only one parameter from the function POLYGON !");
        }
        ADQLOperand replaced = null;
        if (index == 0) {
            replaced = this.coordSys;
            this.setCoordinateSystem(replacer);
        } else if (index >= 1 && index <= this.coordinates.size()) {
            replaced = this.coordinates.get(index - 1);
            this.coordinates.set(index - 1, replacer);
        } else {
            throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" (" + this.toADQL() + ") !");
        }
        this.setPosition(null);
        return replaced;
    }
}

