/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class RegionFunction
extends GeometryFunction {
    protected ADQLOperand parameter;

    public RegionFunction(ADQLOperand param) throws NullPointerException, Exception {
        if (param == null) {
            throw new NullPointerException("The ADQL function REGION must have exactly one parameter !");
        }
        if (!param.isString()) {
            throw new Exception("The only required parameter of a REGION function must be a string literal !");
        }
        this.parameter = param;
    }

    public RegionFunction(RegionFunction toCopy) throws Exception {
        this.parameter = (ADQLOperand)toCopy.parameter.getCopy();
    }

    public ADQLObject getCopy() throws Exception {
        return new RegionFunction(this);
    }

    public String getName() {
        return "REGION";
    }

    public boolean isNumeric() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isGeometry() {
        return true;
    }

    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.parameter};
    }

    public int getNbParameters() {
        return 1;
    }

    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            return this.parameter;
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index == 0) {
            if (replacer == null) {
                throw new NullPointerException("Impossible to remove the only required parameter of a " + this.getName() + " function !");
            }
            if (replacer instanceof ADQLOperand) {
                ADQLOperand replaced = this.parameter;
                this.parameter = replacer;
                this.setPosition(null);
                return replaced;
            }
            throw new Exception("Impossible to replace an ADQLOperand by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ") !");
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\" !");
    }
}

