/*
 * Decompiled with CFR 0.152.
 */
package adql.search;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.search.IReplaceHandler;
import adql.search.SimpleSearchHandler;

public abstract class SimpleReplaceHandler
extends SimpleSearchHandler
implements IReplaceHandler {
    protected boolean replaceActive = false;
    protected int nbReplacement = 0;

    public SimpleReplaceHandler() {
    }

    public SimpleReplaceHandler(boolean recursive) {
        super(recursive);
    }

    public SimpleReplaceHandler(boolean recursive, boolean onlyFirstMatch) {
        super(recursive, onlyFirstMatch);
    }

    public int getNbReplacement() {
        return this.nbReplacement;
    }

    protected void reset() {
        super.reset();
        this.nbReplacement = 0;
    }

    protected void addMatch(ADQLObject matchObj, ADQLIterator it) {
        super.addMatch(matchObj, it);
        if (this.replaceActive && it != null) {
            try {
                ADQLObject replacer = this.getReplacer(matchObj);
                if (replacer == null) {
                    it.remove();
                } else {
                    it.replace(replacer);
                }
                ++this.nbReplacement;
            }
            catch (IllegalStateException ise) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public void searchAndReplace(ADQLObject startObj) {
        this.replaceActive = true;
        this.search(startObj);
        this.replaceActive = false;
    }

    protected abstract ADQLObject getReplacer(ADQLObject var1) throws UnsupportedOperationException;
}

