/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBType;
import adql.db.STCS;
import adql.parser.ParseException;
import adql.query.TextPosition;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.translator.PostgreSQLTranslator;
import adql.translator.TranslationException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.util.PGobject;

public class PgSphereTranslator
extends PostgreSQLTranslator {
    protected static double ANGLE_CIRCLE_TO_POLYGON = 0.19634954084936207;

    public PgSphereTranslator() {
    }

    public PgSphereTranslator(boolean allCaseSensitive) {
        super(allCaseSensitive);
    }

    public PgSphereTranslator(boolean catalog, boolean schema, boolean table, boolean column) {
        super(catalog, schema, table, column);
    }

    public String translate(PointFunction point) throws TranslationException {
        StringBuffer str = new StringBuffer("spoint(");
        str.append("radians(").append(this.translate(point.getCoord1())).append("),");
        str.append("radians(").append(this.translate(point.getCoord2())).append("))");
        return str.toString();
    }

    public String translate(CircleFunction circle) throws TranslationException {
        StringBuffer str = new StringBuffer("scircle(");
        str.append("spoint(radians(").append(this.translate(circle.getCoord1())).append("),");
        str.append("radians(").append(this.translate(circle.getCoord2())).append(")),");
        str.append("radians(").append(this.translate(circle.getRadius())).append("))");
        return str.toString();
    }

    public String translate(BoxFunction box) throws TranslationException {
        StringBuffer str = new StringBuffer("sbox(");
        str.append("spoint(").append("radians(").append(this.translate(box.getCoord1())).append("-(").append(this.translate(box.getWidth())).append("/2.0)),");
        str.append("radians(").append(this.translate(box.getCoord2())).append("-(").append(this.translate(box.getHeight())).append("/2.0))),");
        str.append("spoint(").append("radians(").append(this.translate(box.getCoord1())).append("+(").append(this.translate(box.getWidth())).append("/2.0)),");
        str.append("radians(").append(this.translate(box.getCoord2())).append("+(").append(this.translate(box.getHeight())).append("/2.0))))");
        return str.toString();
    }

    public String translate(PolygonFunction polygon) throws TranslationException {
        try {
            StringBuffer str = new StringBuffer("spoly('{'");
            if (polygon.getNbParameters() > 2) {
                PointFunction point = new PointFunction(polygon.getCoordinateSystem(), polygon.getParameter(1), polygon.getParameter(2));
                str.append(" || ").append(this.translate(point));
                for (int i = 3; i < polygon.getNbParameters() && i + 1 < polygon.getNbParameters(); i += 2) {
                    point.setCoord1(polygon.getParameter(i));
                    point.setCoord2(polygon.getParameter(i + 1));
                    str.append(" || ',' || ").append(this.translate(point));
                }
            }
            str.append(" || '}')");
            return str.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TranslationException(e);
        }
    }

    public String translate(ExtractCoord extractCoord) throws TranslationException {
        StringBuffer str = new StringBuffer("degrees(");
        if (extractCoord.getName().equalsIgnoreCase("COORD1")) {
            str.append("long(");
        } else {
            str.append("lat(");
        }
        str.append(this.translate(extractCoord.getParameter(0))).append("))");
        return str.toString();
    }

    public String translate(DistanceFunction fct) throws TranslationException {
        StringBuffer str = new StringBuffer("degrees(");
        str.append(this.translate(fct.getP1())).append(" <-> ").append(this.translate(fct.getP2())).append(")");
        return str.toString();
    }

    public String translate(AreaFunction areaFunction) throws TranslationException {
        StringBuffer str = new StringBuffer("degrees(degrees(area(");
        str.append(this.translate(areaFunction.getParameter())).append(")))");
        return str.toString();
    }

    public String translate(ContainsFunction fct) throws TranslationException {
        StringBuffer str = new StringBuffer("(");
        str.append(this.translate(fct.getLeftParam())).append(" @ ").append(this.translate(fct.getRightParam())).append(")");
        return str.toString();
    }

    public String translate(IntersectsFunction fct) throws TranslationException {
        StringBuffer str = new StringBuffer("(");
        str.append(this.translate(fct.getLeftParam())).append(" && ").append(this.translate(fct.getRightParam())).append(")");
        return str.toString();
    }

    public String translate(Comparison comp) throws TranslationException {
        if ((comp.getLeftOperand() instanceof ContainsFunction || comp.getLeftOperand() instanceof IntersectsFunction) && (comp.getOperator() == ComparisonOperator.EQUAL || comp.getOperator() == ComparisonOperator.NOT_EQUAL) && comp.getRightOperand().isNumeric()) {
            return this.translate(comp.getLeftOperand()) + " " + comp.getOperator().toADQL() + " '" + this.translate(comp.getRightOperand()) + "'";
        }
        if ((comp.getRightOperand() instanceof ContainsFunction || comp.getRightOperand() instanceof IntersectsFunction) && (comp.getOperator() == ComparisonOperator.EQUAL || comp.getOperator() == ComparisonOperator.NOT_EQUAL) && comp.getLeftOperand().isNumeric()) {
            return "'" + this.translate(comp.getLeftOperand()) + "' " + comp.getOperator().toADQL() + " " + this.translate(comp.getRightOperand());
        }
        return super.translate(comp);
    }

    public DBType convertTypeFromDB(int dbmsType, String rawDbmsTypeName, String dbmsTypeName, String[] params) {
        if (dbmsTypeName == null || dbmsTypeName.trim().length() == 0) {
            return null;
        }
        if ((dbmsTypeName = dbmsTypeName.toLowerCase()).equals("spoint")) {
            return new DBType(DBType.DBDatatype.POINT);
        }
        if (dbmsTypeName.equals("scircle") || dbmsTypeName.equals("sbox") || dbmsTypeName.equals("spoly")) {
            return new DBType(DBType.DBDatatype.REGION);
        }
        return super.convertTypeFromDB(dbmsType, rawDbmsTypeName, dbmsTypeName, params);
    }

    public String convertTypeToDB(DBType type) {
        if (type != null) {
            if (type.type == DBType.DBDatatype.POINT) {
                return "spoint";
            }
            if (type.type == DBType.DBDatatype.REGION) {
                return "spoly";
            }
        }
        return super.convertTypeToDB(type);
    }

    public STCS.Region translateGeometryFromDB(Object jdbcColValue) throws ParseException {
        if (jdbcColValue == null) {
            return null;
        }
        if (!(jdbcColValue instanceof PGobject)) {
            throw new ParseException("Incompatible type! The column value \"" + jdbcColValue.toString() + "\" was supposed to be a geometrical object.");
        }
        PGobject pgo = (PGobject)jdbcColValue;
        if (pgo == null || pgo.getType() == null || pgo.getValue() == null || pgo.getValue().length() == 0) {
            return null;
        }
        String objType = pgo.getType().toLowerCase();
        String geomStr = pgo.getValue();
        if (objType.equals("spoint")) {
            return new PgSphereGeometryParser().parsePoint(geomStr);
        }
        if (objType.equals("scircle")) {
            return new PgSphereGeometryParser().parseCircle(geomStr);
        }
        if (objType.equals("sbox")) {
            return new PgSphereGeometryParser().parseBox(geomStr);
        }
        if (objType.equals("spoly")) {
            return new PgSphereGeometryParser().parsePolygon(geomStr);
        }
        throw new ParseException("Unsupported PgSphere type: \"" + objType + "\"! Impossible to convert the column value \"" + geomStr + "\" into a Region.");
    }

    public Object translateGeometryToDB(STCS.Region region) throws ParseException {
        if (region == null) {
            return null;
        }
        try {
            PGobject dbRegion = new PGobject();
            switch (region.type) {
                case POSITION: {
                    dbRegion.setType("spoint");
                    dbRegion.setValue("(" + region.coordinates[0][0] + "d," + region.coordinates[0][1] + "d)");
                    break;
                }
                case POLYGON: {
                    dbRegion.setType("spoly");
                    StringBuffer buf = new StringBuffer("{");
                    for (int i = 0; i < region.coordinates.length; ++i) {
                        if (i > 0) {
                            buf.append(',');
                        }
                        buf.append('(').append(region.coordinates[i][0]).append("d,").append(region.coordinates[i][1]).append("d)");
                    }
                    buf.append('}');
                    dbRegion.setValue(buf.toString());
                    break;
                }
                case BOX: {
                    dbRegion.setType("spoly");
                    StringBuffer buf = new StringBuffer("{");
                    buf.append('(').append(region.coordinates[0][0] - region.width / 2.0).append("d,").append(region.coordinates[0][1] - region.height / 2.0).append("d),");
                    buf.append('(').append(region.coordinates[0][0] - region.width / 2.0).append("d,").append(region.coordinates[0][1] + region.height / 2.0).append("d),");
                    buf.append('(').append(region.coordinates[0][0] + region.width / 2.0).append("d,").append(region.coordinates[0][1] + region.height / 2.0).append("d),");
                    buf.append('(').append(region.coordinates[0][0] + region.width / 2.0).append("d,").append(region.coordinates[0][1] - region.height / 2.0).append("d)");
                    buf.append('}');
                    dbRegion.setValue(buf.toString());
                    break;
                }
                case CIRCLE: {
                    dbRegion.setType("spoly");
                    dbRegion.setValue(this.circleToPolygon(region.coordinates[0], region.radius));
                    break;
                }
                default: {
                    throw new ParseException("Unsupported geometrical region: \"" + (Object)((Object)region.type) + "\"!");
                }
            }
            return dbRegion;
        }
        catch (SQLException e) {
            return null;
        }
    }

    protected String circleToPolygon(double[] center, double radius) {
        StringBuffer buf = new StringBuffer();
        for (double angle = 0.0; angle < Math.PI * 2; angle += ANGLE_CIRCLE_TO_POLYGON) {
            double x = center[0] + radius * Math.cos(angle);
            double y = center[1] + radius * Math.sin(angle);
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append('(').append(x).append("d,").append(y).append("d)");
        }
        return "{" + buf + "}";
    }

    protected static class PgSphereGeometryParser {
        private int pos;
        private String expr;
        private String token;
        private StringBuffer buffer;
        private static final char OPEN_PAR = '(';
        private static final char CLOSE_PAR = ')';
        private static final char COMMA = ',';
        private static final char LESS_THAN = '<';
        private static final char GREATER_THAN = '>';
        private static final char OPEN_BRACE = '{';
        private static final char CLOSE_BRACE = '}';
        private static final char DEGREE = 'd';
        private static final char HOUR = 'h';
        private static final char MINUTE = 'm';
        private static final char SECOND = 's';

        private void init(String newExpr) {
            this.expr = newExpr == null ? "" : newExpr;
            this.token = null;
            this.buffer = new StringBuffer();
            this.pos = 0;
        }

        private void end() throws ParseException {
            this.skipSpaces();
            if (this.expr.length() > 0 && this.pos < this.expr.length()) {
                throw new ParseException("Unexpected end of PgSphere region expression: \"" + this.expr.substring(this.pos) + "\" was unexpected!", new TextPosition(1, this.pos, 1, this.expr.length()));
            }
            this.buffer = null;
            this.expr = null;
            this.token = null;
        }

        private void skipSpaces() {
            while (this.pos < this.expr.length() && Character.isWhitespace(this.expr.charAt(this.pos))) {
                ++this.pos;
            }
        }

        private String nextToken() throws EOEException {
            this.skipSpaces();
            if (this.pos >= this.expr.length()) {
                throw new EOEException();
            }
            this.buffer.append(this.expr.charAt(this.pos++));
            if (!PgSphereGeometryParser.isSyntaxSeparator(this.buffer.charAt(0))) {
                while (this.pos < this.expr.length() && !PgSphereGeometryParser.isSyntaxSeparator(this.expr.charAt(this.pos))) {
                    if (!Character.isWhitespace(this.expr.charAt(this.pos))) {
                        this.buffer.append(this.expr.charAt(this.pos));
                    }
                    ++this.pos;
                }
            }
            this.token = this.buffer.toString();
            this.buffer.delete(0, this.token.length());
            return this.token;
        }

        private static boolean isSyntaxSeparator(char c) {
            return c == ',' || c == 'd' || c == 'h' || c == 'm' || c == 's' || c == '(' || c == ')' || c == '<' || c == '>' || c == '{' || c == '}';
        }

        private void nextToken(char expected) throws ParseException {
            this.skipSpaces();
            if (this.pos >= this.expr.length()) {
                throw new EOEException();
            }
            char t = this.expr.charAt(this.pos++);
            this.token = new String(new char[]{t});
            if (t != expected) {
                throw new ParseException("Incorrect syntax for \"" + this.expr + "\"! \"" + expected + "\" was expected instead of \"" + t + "\".", new TextPosition(1, this.pos - 1, 1, this.pos));
            }
        }

        public STCS.Region parsePoint(String pgsphereExpr) throws ParseException {
            this.init(pgsphereExpr);
            double[] coord = this.parsePoint();
            this.end();
            return new STCS.Region(null, coord);
        }

        private double[] parsePoint() throws ParseException {
            this.nextToken('(');
            double x = this.parseAngle();
            this.nextToken(',');
            double y = this.parseAngle();
            this.nextToken(')');
            return new double[]{x, y};
        }

        public STCS.Region parseCircle(String pgsphereExpr) throws ParseException {
            this.init(pgsphereExpr);
            this.nextToken('<');
            double[] center = this.parsePoint();
            this.nextToken(',');
            double radius = this.parseAngle();
            this.nextToken('>');
            this.end();
            return new STCS.Region(null, center, radius);
        }

        public STCS.Region parseBox(String pgsphereExpr) throws ParseException {
            this.init(pgsphereExpr);
            this.nextToken('(');
            double[] southwest = this.parsePoint();
            this.nextToken(',');
            double[] northeast = this.parsePoint();
            this.nextToken(')');
            this.end();
            double width = Math.abs(northeast[0] - southwest[0]);
            double height = Math.abs(northeast[1] - southwest[1]);
            double[] center = new double[]{northeast[0] - width / 2.0, northeast[1] - height / 2.0};
            return new STCS.Region(null, center, width, height);
        }

        public STCS.Region parsePolygon(String pgsphereExpr) throws ParseException {
            this.init(pgsphereExpr);
            this.nextToken('{');
            ArrayList<double[]> points = new ArrayList<double[]>(3);
            points.add(this.parsePoint());
            this.nextToken(',');
            points.add(this.parsePoint());
            this.nextToken(',');
            points.add(this.parsePoint());
            while (this.nextToken().length() == 1 && this.token.charAt(0) == ',') {
                points.add(this.parsePoint());
            }
            if (this.token.length() != 1 || this.token.charAt(0) != '}') {
                throw new ParseException("Incorrect syntax for \"" + this.expr + "\"! \"}\" was expected instead of \"" + this.token + "\".", new TextPosition(1, this.pos - this.token.length(), 1, this.pos));
            }
            this.end();
            return new STCS.Region(null, (double[][])points.toArray((T[])new double[points.size()][2]));
        }

        private double parseAngle() throws ParseException {
            int oldPos = this.pos;
            String number = this.nextToken();
            try {
                double degrees = Double.parseDouble(number);
                int sign = degrees < 0.0 ? -1 : 1;
                degrees = Math.abs(degrees);
                oldPos = this.pos;
                try {
                    if (this.nextToken().length() == 1 && this.token.charAt(0) == 'h') {
                        sign *= 15;
                    } else if (this.token.length() != 1 || this.token.charAt(0) != 'd') {
                        degrees = degrees * 180.0 / Math.PI;
                        this.pos -= this.token.length();
                        return degrees * (double)sign;
                    }
                    oldPos = this.pos;
                    number = this.nextToken();
                    if (this.nextToken().length() == 1 && this.token.charAt(0) == 'm') {
                        degrees += Double.parseDouble(number) / 60.0;
                    } else {
                        if (this.token.length() == 1 && this.token.charAt(0) == 's') {
                            return (degrees += Double.parseDouble(number) / 3600.0) * (double)sign;
                        }
                        this.pos = oldPos;
                        return degrees * (double)sign;
                    }
                    oldPos = this.pos;
                    number = this.nextToken();
                    if (this.nextToken().length() == 1 && this.token.charAt(0) == 's') {
                        degrees += Double.parseDouble(number) / 3600.0;
                    } else {
                        this.pos = oldPos;
                    }
                }
                catch (EOEException ex) {
                    this.pos = oldPos;
                }
                return degrees * (double)sign;
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Incorrect numeric syntax: \"" + number + "\"!", new TextPosition(1, this.pos - this.token.length(), 1, this.pos));
            }
        }

        private static class EOEException
        extends ParseException {
            private static final long serialVersionUID = 1L;

            public EOEException() {
                super("Unexpected End Of PgSphere Expression!");
            }
        }
    }
}

