/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBType;
import adql.db.STCS;
import adql.parser.ParseException;
import adql.query.IdentifierField;
import adql.query.operand.StringConstant;
import adql.query.operand.function.MathFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.translator.JDBCTranslator;
import adql.translator.TranslationException;

public class PostgreSQLTranslator
extends JDBCTranslator {
    protected byte caseSensitivity = 0;

    public PostgreSQLTranslator() {
        this.caseSensitivity = (byte)15;
    }

    public PostgreSQLTranslator(boolean allCaseSensitive) {
        this.caseSensitivity = (byte)(allCaseSensitive ? 15 : 0);
    }

    public PostgreSQLTranslator(boolean catalog, boolean schema, boolean table, boolean column) {
        this.caseSensitivity = IdentifierField.CATALOG.setCaseSensitive(this.caseSensitivity, catalog);
        this.caseSensitivity = IdentifierField.SCHEMA.setCaseSensitive(this.caseSensitivity, schema);
        this.caseSensitivity = IdentifierField.TABLE.setCaseSensitive(this.caseSensitivity, table);
        this.caseSensitivity = IdentifierField.COLUMN.setCaseSensitive(this.caseSensitivity, column);
    }

    public boolean isCaseSensitive(IdentifierField field) {
        return field == null ? false : field.isCaseSensitive(this.caseSensitivity);
    }

    public String translate(StringConstant strConst) throws TranslationException {
        if (strConst.getValue() != null && strConst.getValue().contains("\\")) {
            return "E'" + strConst.getValue() + "'";
        }
        return super.translate(strConst);
    }

    public String translate(MathFunction fct) throws TranslationException {
        switch (fct.getType()) {
            case LOG: {
                return "ln(" + (fct.getNbParameters() >= 1 ? this.translate(fct.getParameter(0)) : "") + ")";
            }
            case LOG10: {
                return "log(10, " + (fct.getNbParameters() >= 1 ? this.translate(fct.getParameter(0)) : "") + ")";
            }
            case RAND: {
                return "random()";
            }
            case TRUNCATE: {
                return "trunc(" + (fct.getNbParameters() >= 2 ? this.translate(fct.getParameter(0)) + ", " + this.translate(fct.getParameter(1)) : "") + ")";
            }
        }
        return this.getDefaultADQLFunction(fct);
    }

    public String translate(ExtractCoord extractCoord) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoord);
    }

    public String translate(ExtractCoordSys extractCoordSys) throws TranslationException {
        return this.getDefaultADQLFunction(extractCoordSys);
    }

    public String translate(AreaFunction areaFunction) throws TranslationException {
        return this.getDefaultADQLFunction(areaFunction);
    }

    public String translate(CentroidFunction centroidFunction) throws TranslationException {
        return this.getDefaultADQLFunction(centroidFunction);
    }

    public String translate(DistanceFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    public String translate(ContainsFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    public String translate(IntersectsFunction fct) throws TranslationException {
        return this.getDefaultADQLFunction(fct);
    }

    public String translate(BoxFunction box) throws TranslationException {
        return this.getDefaultADQLFunction(box);
    }

    public String translate(CircleFunction circle) throws TranslationException {
        return this.getDefaultADQLFunction(circle);
    }

    public String translate(PointFunction point) throws TranslationException {
        return this.getDefaultADQLFunction(point);
    }

    public String translate(PolygonFunction polygon) throws TranslationException {
        return this.getDefaultADQLFunction(polygon);
    }

    public String translate(RegionFunction region) throws TranslationException {
        return this.getDefaultADQLFunction(region);
    }

    public DBType convertTypeFromDB(int dbmsType, String rawDbmsTypeName, String dbmsTypeName, String[] params) {
        if (dbmsTypeName == null || dbmsTypeName.trim().length() == 0) {
            return null;
        }
        dbmsTypeName = dbmsTypeName.toLowerCase();
        int lengthParam = -1;
        if (params != null && params.length > 0) {
            try {
                lengthParam = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (dbmsTypeName.equals("smallint") || dbmsTypeName.equals("int2") || dbmsTypeName.equals("smallserial") || dbmsTypeName.equals("serial2") || dbmsTypeName.equals("boolean") || dbmsTypeName.equals("bool")) {
            return new DBType(DBType.DBDatatype.SMALLINT);
        }
        if (dbmsTypeName.equals("integer") || dbmsTypeName.equals("int") || dbmsTypeName.equals("int4") || dbmsTypeName.equals("serial") || dbmsTypeName.equals("serial4")) {
            return new DBType(DBType.DBDatatype.INTEGER);
        }
        if (dbmsTypeName.equals("bigint") || dbmsTypeName.equals("int8") || dbmsTypeName.equals("bigserial") || dbmsTypeName.equals("bigserial8")) {
            return new DBType(DBType.DBDatatype.BIGINT);
        }
        if (dbmsTypeName.equals("real") || dbmsTypeName.equals("float4")) {
            return new DBType(DBType.DBDatatype.REAL);
        }
        if (dbmsTypeName.equals("double precision") || dbmsTypeName.equals("float8")) {
            return new DBType(DBType.DBDatatype.DOUBLE);
        }
        if (dbmsTypeName.equals("bit")) {
            return new DBType(DBType.DBDatatype.BINARY, lengthParam);
        }
        if (dbmsTypeName.equals("bit varying") || dbmsTypeName.equals("varbit")) {
            return new DBType(DBType.DBDatatype.VARBINARY, lengthParam);
        }
        if (dbmsTypeName.equals("char") || dbmsTypeName.equals("character")) {
            return new DBType(DBType.DBDatatype.CHAR, lengthParam);
        }
        if (dbmsTypeName.equals("varchar") || dbmsTypeName.equals("character varying")) {
            return new DBType(DBType.DBDatatype.VARCHAR, lengthParam);
        }
        if (dbmsTypeName.equals("bytea")) {
            return new DBType(DBType.DBDatatype.BLOB);
        }
        if (dbmsTypeName.equals("text")) {
            return new DBType(DBType.DBDatatype.CLOB);
        }
        if (dbmsTypeName.equals("timestamp") || dbmsTypeName.equals("timestamptz") || dbmsTypeName.equals("time") || dbmsTypeName.equals("timetz") || dbmsTypeName.equals("date")) {
            return new DBType(DBType.DBDatatype.TIMESTAMP);
        }
        return null;
    }

    public String convertTypeToDB(DBType type) {
        if (type == null) {
            return "VARCHAR";
        }
        switch (type.type) {
            case SMALLINT: 
            case INTEGER: 
            case REAL: 
            case BIGINT: 
            case CHAR: 
            case VARCHAR: 
            case TIMESTAMP: {
                return type.type.toString();
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case BINARY: 
            case VARBINARY: {
                return "bytea";
            }
            case BLOB: {
                return "bytea";
            }
            case CLOB: {
                return "TEXT";
            }
        }
        return "VARCHAR";
    }

    public STCS.Region translateGeometryFromDB(Object jdbcColValue) throws ParseException {
        throw new ParseException("Unsupported geometrical value! The value \"" + jdbcColValue + "\" can not be parsed as a region.");
    }

    public Object translateGeometryToDB(STCS.Region region) throws ParseException {
        throw new ParseException("Geometries can not be uploaded in the database in this implementation!");
    }
}

