/*
 * Decompiled with CFR 0.152.
 */
package cds.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextualSearchList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    public final KeyExtractor<E> keyExtractor;
    protected final HashMap<String, ArrayList<E>> csMap;
    protected final HashMap<String, ArrayList<E>> ncsMap;

    public TextualSearchList() {
        this(new DefaultKeyExtractor());
    }

    public TextualSearchList(KeyExtractor<E> keyExtractor) {
        this.keyExtractor = keyExtractor;
        this.csMap = new HashMap();
        this.ncsMap = new HashMap();
    }

    public TextualSearchList(int initialCapacity) {
        this(initialCapacity, new DefaultKeyExtractor());
    }

    public TextualSearchList(int initialCapacity, KeyExtractor<E> keyExtractor) {
        super(initialCapacity);
        this.keyExtractor = keyExtractor;
        this.csMap = new HashMap(initialCapacity);
        this.ncsMap = new HashMap(initialCapacity);
    }

    public TextualSearchList(Collection<? extends E> c) {
        this(c, new DefaultKeyExtractor());
    }

    public TextualSearchList(Collection<? extends E> c, KeyExtractor<E> keyExtractor) {
        this.keyExtractor = keyExtractor;
        this.csMap = new HashMap(c.size());
        this.ncsMap = new HashMap(c.size());
        this.addAll(c);
    }

    @Override
    public boolean contains(Object o) {
        try {
            if (o == null) {
                return false;
            }
            Object object = o;
            return !this.get(this.getKey(object)).isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public final ArrayList<E> get(String key) {
        return this.get(key, false);
    }

    public ArrayList<E> get(String key, boolean caseSensitive) {
        ArrayList<E> founds;
        if (key == null) {
            return new ArrayList(0);
        }
        ArrayList<E> arrayList = founds = caseSensitive ? this.csMap.get(key) : this.ncsMap.get(key.toLowerCase());
        if (founds == null) {
            return new ArrayList(0);
        }
        return (ArrayList)founds.clone();
    }

    private final String getKey(E value) throws NullPointerException, IllegalArgumentException {
        String key = this.keyExtractor.getKey(value);
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed in a TextualSearchList !");
        }
        return key;
    }

    private final void putIntoMaps(String key, E value) {
        TextualSearchList.putIntoMap(this.csMap, key, value);
        TextualSearchList.putIntoMap(this.ncsMap, key.toLowerCase(), value);
    }

    private static final <E> void putIntoMap(HashMap<String, ArrayList<E>> map, String key, E value) {
        ArrayList<E> lst = map.get(key);
        if (lst == null) {
            lst = new ArrayList();
            lst.add(value);
            map.put(key, lst);
        } else {
            lst.add(value);
        }
    }

    @Override
    public boolean add(E obj) throws NullPointerException, IllegalArgumentException {
        if (obj == null) {
            throw new NullPointerException("Null objects are not allowed in a TextualSearchList !");
        }
        String key = this.getKey(obj);
        if (key == null) {
            return false;
        }
        if (super.add(obj)) {
            this.putIntoMaps(key, obj);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E obj) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException {
        if (obj == null) {
            throw new NullPointerException("Null objects are not allowed in a TextualSearchList !");
        }
        String key = this.getKey(obj);
        if (key == null) {
            return;
        }
        super.add(index, obj);
        if (this.get(index).equals(obj)) {
            this.putIntoMaps(key, obj);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) throws NullPointerException, IllegalArgumentException {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        for (E obj : c) {
            modified = this.add(obj) || modified;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        int ind = index;
        for (E obj : c) {
            this.add(ind++, obj);
            modified = this.get(ind).equals(obj);
        }
        return modified;
    }

    @Override
    public E set(int index, E obj) throws NullPointerException, IllegalArgumentException {
        if (obj == null) {
            throw new NullPointerException("Null objects are not allowed in a TextualSearchList !");
        }
        if (this.get(index).equals(obj)) {
            return obj;
        }
        String key = this.getKey(obj);
        E old = super.set(index, obj);
        String oldKey = this.keyExtractor.getKey(old);
        this.removeFromMaps(oldKey, old);
        this.putIntoMaps(key, obj);
        return old;
    }

    @Override
    public void clear() {
        super.clear();
        this.csMap.clear();
        this.ncsMap.clear();
    }

    private final void removeFromMaps(String key, E value) {
        TextualSearchList.removeFromMap(this.csMap, key, value);
        TextualSearchList.removeFromMap(this.ncsMap, key.toLowerCase(), value);
    }

    private static final <E> void removeFromMap(HashMap<String, ArrayList<E>> map, String key, E value) {
        ArrayList<E> lst = map.get(key);
        if (lst != null) {
            lst.remove(value);
            if (lst.isEmpty()) {
                map.remove(key);
            }
        }
    }

    @Override
    public E remove(int index) {
        Object removed = super.remove(index);
        if (removed != null) {
            String key = this.keyExtractor.getKey(removed);
            this.removeFromMaps(key, removed);
        }
        return removed;
    }

    @Override
    public boolean remove(Object obj) {
        boolean removed = super.remove(obj);
        if (removed) {
            String key = this.keyExtractor.getKey(obj);
            this.removeFromMaps(key, obj);
        }
        return removed;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        if (fromIndex < 0 || fromIndex >= this.size() || toIndex < 0 || toIndex >= this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Incorrect range indexes: from " + fromIndex + " to " + toIndex + " !");
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            this.remove(i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DefaultKeyExtractor<E>
    implements KeyExtractor<E> {
        protected DefaultKeyExtractor() {
        }

        @Override
        public String getKey(E obj) {
            return obj.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KeyExtractor<E> {
        public String getKey(E var1);
    }
}

