/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.registry;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import uk.ac.starlink.registry.RegistryQueryException;
import uk.ac.starlink.registry.ResourceSink;
import uk.ac.starlink.registry.SoapClient;
import uk.ac.starlink.registry.SoapRequest;

public abstract class AbstractRegistryClient<R> {
    private static final String RI_NS = "http://www.ivoa.net/xml/RegistryInterface/v1.0";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private final SoapClient soapClient_;

    public AbstractRegistryClient(SoapClient soapClient) {
        this.soapClient_ = soapClient;
    }

    protected abstract ContentHandler createResourceHandler(ResourceSink<R> var1);

    public URL getEndpoint() {
        return this.soapClient_.getEndpoint();
    }

    public List<R> getResourceList(SoapRequest request) throws IOException {
        final ArrayList resList = new ArrayList();
        ResourceSink sink = new ResourceSink<R>(){

            @Override
            public void addResource(R resource) {
                resList.add(resource);
            }
        };
        try {
            this.soapClient_.execute(request, this.createResourceHandler(sink));
        }
        catch (SAXException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "SAX parse error";
            }
            throw (IOException)new IOException(msg).initCause(e);
        }
        return resList;
    }

    public Iterator<R> getResourceIterator(final SoapRequest request) throws IOException {
        final IteratorResourceSink sink = new IteratorResourceSink();
        final ContentHandler resourceHandler = this.createResourceHandler(sink);
        new Thread("Registry" + request.getAction()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractRegistryClient.this.soapClient_.execute(request, resourceHandler);
                }
                catch (Throwable e) {
                    sink.setError(e);
                }
                finally {
                    sink.close();
                }
            }
        }.start();
        return sink;
    }

    private class IteratorResourceSink<R>
    implements ResourceSink<R>,
    Iterator<R> {
        private final List<Object> queue_ = new LinkedList<Object>();
        private volatile Throwable error_;
        private volatile boolean done_;

        private IteratorResourceSink() {
        }

        @Override
        public synchronized void addResource(R resource) {
            this.queue_.add(resource);
            this.notifyAll();
        }

        synchronized void setError(Throwable error) {
            this.queue_.add(error);
            this.notifyAll();
        }

        synchronized void close() {
            this.done_ = true;
            this.notifyAll();
        }

        @Override
        public synchronized boolean hasNext() {
            while (!this.done_ && this.queue_.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.setError(e);
                }
            }
            return !this.queue_.isEmpty();
        }

        @Override
        public synchronized R next() {
            if (this.hasNext()) {
                Object item = this.queue_.remove(0);
                if (item instanceof Throwable) {
                    throw new RegistryQueryException((Throwable)item);
                }
                return (R)item;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

