/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.registry.AbstractRegistryClient;
import uk.ac.starlink.registry.BasicCapability;
import uk.ac.starlink.registry.BasicResource;
import uk.ac.starlink.registry.ResourceSink;
import uk.ac.starlink.registry.SoapClient;

public class BasicRegistryClient
extends AbstractRegistryClient<BasicResource> {
    public BasicRegistryClient(SoapClient soapClient) {
        super(soapClient);
    }

    @Override
    protected ContentHandler createResourceHandler(ResourceSink<BasicResource> sink) {
        return new BasicResourceHandler(sink);
    }

    private static class BasicResourceHandler
    extends DefaultHandler {
        private static final String RESOURCE_PATH = "/SearchResponse/VOResources/Resource";
        private static final String TITLE_PATH = "/SearchResponse/VOResources/Resource/title";
        private static final String IDENTIFIER_PATH = "/SearchResponse/VOResources/Resource/identifier";
        private static final String SHORTNAME_PATH = "/SearchResponse/VOResources/Resource/shortName";
        private static final String STATUS_PATH = "/SearchResponse/VOResources/Resource/@status";
        private static final String PUBLISHER_PATH = "/SearchResponse/VOResources/Resource/curation/publisher";
        private static final String CONTACTNAME_PATH = "/SearchResponse/VOResources/Resource/curation/contact/name";
        private static final String CONTACTEMAIL_PATH = "/SearchResponse/VOResources/Resource/curation/contact/email";
        private static final String SUBJECT_PATH = "/SearchResponse/VOResources/Resource/content/subject";
        private static final String REFURL_PATH = "/SearchResponse/VOResources/Resource/content/referenceURL";
        private static final String CAPABILITY_PATH = "/SearchResponse/VOResources/Resource/capability";
        private static final String STDID_PATH = "/SearchResponse/VOResources/Resource/capability/@standardID";
        private static final String XSITYPE_PATH = "/SearchResponse/VOResources/Resource/capability/@xsi:type";
        private static final String DESCRIPTION_PATH = "/SearchResponse/VOResources/Resource/capability/description";
        private static final String CAPINTERFACE_PATH = "/SearchResponse/VOResources/Resource/capability/interface";
        private static final String ACCESSURL_PATH = "/SearchResponse/VOResources/Resource/capability/interface/accessURL";
        private static final String VERSION_PATH = "/SearchResponse/VOResources/Resource/capability/interface/@version";
        private Store resourceStore_;
        private Store capabilityStore_;
        private StringBuffer txtBuf_;
        private List<BasicCapability> capabilityList_;
        private final Set<String> resourcePathSet_;
        private final Set<String> capabilityPathSet_;
        private final StringBuffer path_;
        private final ResourceSink<BasicResource> sink_;

        public BasicResourceHandler(ResourceSink<BasicResource> sink) {
            this.sink_ = sink;
            this.path_ = new StringBuffer();
            this.resourcePathSet_ = new HashSet<String>(Arrays.asList(TITLE_PATH, IDENTIFIER_PATH, SHORTNAME_PATH, PUBLISHER_PATH, CONTACTNAME_PATH, CONTACTEMAIL_PATH, SUBJECT_PATH, REFURL_PATH, STATUS_PATH));
            this.capabilityPathSet_ = new HashSet<String>(Arrays.asList(STDID_PATH, XSITYPE_PATH, DESCRIPTION_PATH, ACCESSURL_PATH, VERSION_PATH));
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                this.path_.append('/').append(localName);
                String path = this.path_.toString();
                if (RESOURCE_PATH.equals(path)) {
                    this.resourceStore_ = new Store();
                    this.capabilityList_ = new ArrayList<BasicCapability>();
                } else if (CAPABILITY_PATH.equals(path)) {
                    this.capabilityStore_ = new Store();
                } else if (this.resourcePathSet_.contains(path) || this.capabilityPathSet_.contains(path)) {
                    this.txtBuf_ = new StringBuffer();
                }
                int natt = atts.getLength();
                for (int ia = 0; ia < natt; ++ia) {
                    String apath = path + "/@" + atts.getQName(ia);
                    if (this.resourcePathSet_.contains(apath)) {
                        this.resourceStore_.put(apath, atts.getValue(ia));
                        continue;
                    }
                    if (!this.capabilityPathSet_.contains(apath)) continue;
                    this.capabilityStore_.put(apath, atts.getValue(ia));
                }
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void endElement(String namepaceURI, String localName, String qName) throws SAXException {
            try {
                String path = this.path_.toString();
                if (RESOURCE_PATH.equals(path)) {
                    BasicCapability[] caps = this.capabilityList_.toArray(new BasicCapability[0]);
                    this.capabilityList_ = null;
                    this.sink_.addResource(BasicResourceHandler.createBasicResource(this.resourceStore_, caps));
                    this.resourceStore_ = null;
                } else if (CAPINTERFACE_PATH.equals(path)) {
                    this.capabilityList_.add(BasicResourceHandler.createBasicCapability(this.capabilityStore_));
                    Iterator<String> it = this.capabilityStore_.keySet().iterator();
                    while (it.hasNext()) {
                        if (!it.next().startsWith(path)) continue;
                        it.remove();
                    }
                } else if (CAPABILITY_PATH.equals(path)) {
                    this.capabilityStore_ = null;
                } else if (this.resourcePathSet_.contains(path)) {
                    this.resourceStore_.put(path, this.txtBuf_.toString());
                    this.txtBuf_ = null;
                } else if (this.capabilityPathSet_.contains(path)) {
                    this.capabilityStore_.put(path, this.txtBuf_.toString());
                    this.txtBuf_ = null;
                }
                this.path_.setLength(this.path_.length() - localName.length() - 1);
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.txtBuf_ != null) {
                this.txtBuf_.append(ch, start, length);
            }
        }

        private static BasicResource createBasicResource(Store rStore, BasicCapability[] caps) {
            BasicResource resource = new BasicResource();
            resource.setCapabilities(caps);
            resource.setTitle(rStore.removeScalar(TITLE_PATH));
            resource.setIdentifier(rStore.removeScalar(IDENTIFIER_PATH));
            resource.setShortName(rStore.removeScalar(SHORTNAME_PATH));
            resource.setPublisher(rStore.removeScalar(PUBLISHER_PATH));
            resource.setContact(BasicResourceHandler.makeContact(rStore.removeScalar(CONTACTNAME_PATH), rStore.removeScalar(CONTACTEMAIL_PATH)));
            resource.setReferenceUrl(rStore.removeScalar(REFURL_PATH));
            resource.setSubjects(rStore.removeArray(SUBJECT_PATH));
            String status = rStore.removeScalar(STATUS_PATH);
            assert (rStore.keySet().isEmpty());
            return resource;
        }

        private static BasicCapability createBasicCapability(Store cStore) {
            BasicCapability cap = new BasicCapability();
            cap.setAccessUrl(cStore.removeScalar(ACCESSURL_PATH));
            cap.setDescription(cStore.removeScalar(DESCRIPTION_PATH));
            cap.setStandardId(cStore.removeScalar(STDID_PATH));
            cap.setVersion(cStore.removeScalar(VERSION_PATH));
            cap.setXsiType(cStore.removeScalar(XSITYPE_PATH));
            assert (cStore.keySet().isEmpty());
            return cap;
        }

        private static String makeContact(String name, String email) {
            if (email != null && name != null) {
                return name + " <" + email + ">";
            }
            if (email != null) {
                return email;
            }
            if (name != null) {
                return name;
            }
            return null;
        }

        private static class Store {
            private final Map<String, Collection<String>> map_ = new HashMap<String, Collection<String>>();

            Store() {
            }

            public void put(String key, String value) {
                String tval = value.trim();
                if (tval.length() > 0) {
                    if (!this.map_.containsKey(key)) {
                        this.map_.put(key, new ArrayList());
                    }
                    this.map_.get(key).add(tval);
                }
            }

            public String removeScalar(String key) {
                Collection<String> list = this.map_.remove(key);
                return list == null ? null : list.iterator().next();
            }

            public String[] removeArray(String key) {
                Collection<String> list = this.map_.remove(key);
                return list == null ? new String[]{} : list.toArray(new String[0]);
            }

            public Set<String> keySet() {
                return this.map_.keySet();
            }
        }
    }
}

