/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.registry;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ac.starlink.registry.BasicCapability;
import uk.ac.starlink.registry.BasicRegistryClient;
import uk.ac.starlink.registry.BasicResource;
import uk.ac.starlink.registry.RegistryRequestFactory;
import uk.ac.starlink.registry.SoapClient;
import uk.ac.starlink.registry.SoapRequest;

public class RegClientTest {
    public static void main(String[] args) throws IOException {
        SoapRequest req;
        Map<String, URL> knownRegMap = RegClientTest.getKnownRegMap();
        StringBuffer ubuf = new StringBuffer();
        ubuf.append(RegClientTest.class.getName()).append(" [-e <reg-endpoint-url>");
        for (String nickname : knownRegMap.keySet()) {
            ubuf.append('|').append(nickname);
        }
        ubuf.append(']');
        ubuf.append(" [-v]");
        ubuf.append(" [-adqls <adqls-query> | -keywords <keywords>]");
        String usage = ubuf.toString();
        URL endpoint = knownRegMap.get("ag");
        String adqls = "capability/@standardID = 'ivo://ivoa.net/std/SSA'";
        String keywords = "lockman 2mass";
        boolean verbose = false;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-e") && it.hasNext()) {
                it.remove();
                String e = (String)it.next();
                it.remove();
                endpoint = knownRegMap.containsKey(e) ? knownRegMap.get(e) : new URL(e);
                continue;
            }
            if (arg.equals("-adqls") && it.hasNext()) {
                keywords = null;
                it.remove();
                adqls = (String)it.next();
                it.remove();
                continue;
            }
            if (arg.equals("-keywords") && it.hasNext()) {
                adqls = null;
                it.remove();
                keywords = (String)it.next();
                it.remove();
                continue;
            }
            if (arg.equals("-v")) {
                it.remove();
                verbose = true;
                continue;
            }
            if (arg.startsWith("-h")) {
                System.out.println("\n" + usage + "\n");
                return;
            }
            System.err.println("\n" + usage + "\n");
            System.exit(1);
        }
        SoapClient sclient = new SoapClient(endpoint);
        if (verbose) {
            sclient.setEchoStream(System.err);
        }
        BasicRegistryClient rclient = new BasicRegistryClient(sclient);
        if (adqls != null) {
            req = RegistryRequestFactory.adqlsSearch(adqls);
        } else if (keywords != null) {
            req = RegistryRequestFactory.keywordSearch(keywords.split("\\s+"), false);
        } else {
            throw new AssertionError((Object)"No search term");
        }
        Iterator it2 = rclient.getResourceIterator(req);
        while (it2.hasNext()) {
            BasicResource res = (BasicResource)it2.next();
            BasicCapability[] caps = res.getCapabilities();
            System.out.println(RegClientTest.formatResource(res));
            for (int ic = 0; ic < caps.length; ++ic) {
                System.out.println("\t" + RegClientTest.formatCapability(caps[ic]));
            }
        }
    }

    private static String formatResource(BasicResource res) {
        return new StringBuffer().append(res.getIdentifier()).append("  ---  ").append(res.getShortName()).toString();
    }

    private static String formatCapability(BasicCapability cap) {
        return new StringBuffer().append(cap.getStandardId()).append('\t').append(cap.getAccessUrl()).toString();
    }

    public static Map<String, URL> getKnownRegMap() {
        HashMap<String, URL> map = new HashMap<String, URL>();
        try {
            map.put("ag", new URL("http://registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0"));
            map.put("nvo", new URL("http://nvo.stsci.edu/vor10/ristandardservice.asmx"));
            map.put("euro", new URL("http://registry.euro-vo.org/services/RegistrySearch"));
        }
        catch (MalformedURLException e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"do what?"))).initCause(e);
        }
        return map;
    }
}

