/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListModel;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.MessageDefinition;
import uk.ac.starlink.plastic.ValueType;
import uk.ac.starlink.plastic.ValueTypeException;

class MessageValidator {
    private final Map messageMap_ = new HashMap();
    private ListModel appsList_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MessageValidator() {
        MessageDefinition[] defs = MessageDefinition.getKnownMessages();
        for (int i = 0; i < defs.length; ++i) {
            MessageDefinition def = defs[i];
            URI id = def.getId();
            if (!$assertionsDisabled && this.messageMap_.containsKey(id)) {
                throw new AssertionError();
            }
            this.messageMap_.put(id, def);
            if (!$assertionsDisabled && !this.messageMap_.containsKey(id)) {
                throw new AssertionError();
            }
        }
    }

    public MessageDefinition getDefinition(URI msgId) {
        return (MessageDefinition)this.messageMap_.get(msgId);
    }

    public String[] validateRequest(URI sender, URI message, List argList) {
        ApplicationItem app;
        ArrayList<String> warningList = new ArrayList<String>();
        if (this.appsList_ != null && (app = MessageValidator.getRegisteredApplication(this.appsList_, sender)) == null) {
            warningList.add("Sent from unregistered application: " + sender);
        }
        if (!this.messageMap_.containsKey(message)) {
            warningList.add("First sighting of unknown message ID: " + message);
            try {
                MessageDefinition def = MessageValidator.inferMessageDefinition(message, argList, null);
                this.messageMap_.put(message, def);
            }
            catch (ValueTypeException e) {
                warningList.add(e.getMessage());
                Object[] anyArgs = new ValueType[20];
                Arrays.fill(anyArgs, ValueType.ANY);
                MessageDefinition def = new MessageDefinition(message.toString(), (ValueType[])anyArgs, ValueType.ANY, 0);
                this.messageMap_.put(message, def);
            }
        } else {
            MessageDefinition msgDef = (MessageDefinition)this.messageMap_.get(message);
            Object[] args = argList.toArray();
            ValueType[] types = msgDef.getArgTypes();
            int nreq = msgDef.getRequiredArgs();
            if (args.length < nreq) {
                warningList.add("Too few arguments (" + args.length + " < " + nreq + ")");
            }
            for (int i = 0; i < args.length && i < types.length; ++i) {
                try {
                    types[i].checkJavaValue(args[i]);
                    continue;
                }
                catch (ValueTypeException e) {
                    warningList.add("Argument #" + i + " type mismatch: " + e.getMessage());
                }
            }
        }
        return warningList.toArray(new String[0]);
    }

    public String[] validateResponse(URI message, Object retval) {
        if (this.messageMap_.containsKey(message)) {
            MessageDefinition msgDef = (MessageDefinition)this.messageMap_.get(message);
            try {
                msgDef.getReturnType().checkJavaValue(retval);
            }
            catch (ValueTypeException e) {
                return new String[]{"Return value type mismatch: " + e.getMessage()};
            }
        }
        return new String[0];
    }

    private static ApplicationItem getRegisteredApplication(ListModel list, URI appId) {
        for (int i = 0; i < list.getSize(); ++i) {
            Object item = list.getElementAt(i);
            ApplicationItem app = (ApplicationItem)item;
            if (!app.getId().equals(appId)) continue;
            return app;
        }
        return null;
    }

    private static MessageDefinition inferMessageDefinition(URI message, List argList, Object rtnValue) throws ValueTypeException {
        ValueType[] types = new ValueType[argList.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ValueType.inferValueType(argList.get(i));
        }
        ValueType rtnType = rtnValue == null ? ValueType.ANY : ValueType.inferValueType(rtnValue);
        return new MessageDefinition(message.toString(), types, rtnType, 0);
    }

    static {
        $assertionsDisabled = !MessageValidator.class.desiredAssertionStatus();
    }
}

