/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Table;
import java.util.ArrayList;

public class Row
implements Element {
    protected int columns;
    protected int currentColumn;
    protected boolean[] reserved;
    protected Object[] cells;

    protected Row(int n) {
        this.columns = n;
        this.reserved = new boolean[n];
        this.cells = new Object[n];
        this.currentColumn = 0;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 21;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public boolean isContent() {
        return true;
    }

    public boolean isNestable() {
        return false;
    }

    int addElement(Object object, int n) {
        int n2;
        if (object == null) {
            throw new NullPointerException("addCell - null argument");
        }
        if (n < 0 || n > this.columns) {
            throw new IndexOutOfBoundsException("addCell - illegal column argument");
        }
        if (this.getObjectID(object) != 1 && this.getObjectID(object) != 2) {
            throw new IllegalArgumentException("addCell - only Cells or Tables allowed");
        }
        int n3 = n2 = Cell.class.isInstance(object) ? ((Cell)object).getColspan() : 1;
        if (!this.reserve(n, n2)) {
            return -1;
        }
        this.cells[n] = object;
        this.currentColumn += n2 - 1;
        return n;
    }

    void setElement(Object object, int n) {
        if (this.reserved[n]) {
            throw new IllegalArgumentException("setElement - position already taken");
        }
        this.cells[n] = object;
        if (object != null) {
            this.reserved[n] = true;
        }
    }

    boolean reserve(int n, int n2) {
        if (n < 0 || n + n2 > this.columns) {
            throw new IndexOutOfBoundsException("reserve - incorrect column/size");
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.reserved[i]) {
                for (int j = i; j >= n; --j) {
                    this.reserved[j] = false;
                }
                return false;
            }
            this.reserved[i] = true;
        }
        return true;
    }

    boolean isReserved(int n) {
        return this.reserved[n];
    }

    int getObjectID(Object object) {
        if (object == null) {
            return 0;
        }
        if (Cell.class.isInstance(object)) {
            return 1;
        }
        if (Table.class.isInstance(object)) {
            return 2;
        }
        return -1;
    }

    public Object getCell(int n) {
        if (n < 0 || n > this.columns) {
            throw new IndexOutOfBoundsException("getCell at illegal index :" + n + " max is " + this.columns);
        }
        return this.cells[n];
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.columns; ++i) {
            if (this.cells[i] == null) continue;
            return false;
        }
        return true;
    }

    public int getColumns() {
        return this.columns;
    }
}

