/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.XfaForm;
import java.util.ArrayList;
import java.util.HashMap;

public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    HashMap fields;
    private boolean append;
    private HashMap extensionFonts = new HashMap();
    private XfaForm xfa;
    private boolean generateAppearances = true;
    private HashMap localFonts = new HashMap();
    private static final HashMap stdFieldFontNames = new HashMap();
    private static final PdfName[] buttonRemove;

    AcroFields(PdfReader pdfReader, PdfWriter pdfWriter) {
        this.reader = pdfReader;
        this.writer = pdfWriter;
        try {
            this.xfa = new XfaForm(pdfReader);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        if (pdfWriter instanceof PdfStamperImp) {
            this.append = ((PdfStamperImp)pdfWriter).isAppend();
        }
        this.fill();
    }

    void fill() {
        Object object;
        Object object2;
        PdfObject pdfObject;
        PdfDictionary pdfDictionary;
        PdfObject pdfObject2;
        this.fields = new HashMap();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary2 == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.FIELDS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
            PdfDictionary pdfDictionary3 = this.reader.getPageNRelease(i);
            pdfObject2 = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary3.get(PdfName.ANNOTS), pdfDictionary3);
            if (pdfObject2 == null) continue;
            for (int j = 0; j < ((PdfArray)pdfObject2).size(); ++j) {
                Object object3;
                pdfDictionary = ((PdfArray)pdfObject2).getAsDict(j);
                if (pdfDictionary == null) {
                    PdfReader.releaseLastXrefPartial(((PdfArray)pdfObject2).getAsIndirectObject(j));
                    continue;
                }
                if (!PdfName.WIDGET.equals(pdfDictionary.getAsName(PdfName.SUBTYPE))) {
                    PdfReader.releaseLastXrefPartial(((PdfArray)pdfObject2).getAsIndirectObject(j));
                    continue;
                }
                pdfObject = pdfDictionary;
                object2 = new PdfDictionary();
                ((PdfDictionary)object2).putAll(pdfDictionary);
                object = "";
                PdfDictionary pdfDictionary4 = null;
                PdfObject pdfObject3 = null;
                while (pdfDictionary != null) {
                    ((PdfDictionary)object2).mergeDifferent(pdfDictionary);
                    object3 = pdfDictionary.getAsString(PdfName.T);
                    if (object3 != null) {
                        object = ((PdfString)object3).toUnicodeString() + "." + (String)object;
                    }
                    if (pdfObject3 == null && pdfDictionary.get(PdfName.V) != null) {
                        pdfObject3 = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.V));
                    }
                    if (pdfDictionary4 == null && object3 != null) {
                        pdfDictionary4 = pdfDictionary;
                        if (pdfDictionary.get(PdfName.V) == null && pdfObject3 != null) {
                            pdfDictionary4.put(PdfName.V, pdfObject3);
                        }
                    }
                    pdfDictionary = pdfDictionary.getAsDict(PdfName.PARENT);
                }
                if (((String)object).length() > 0) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                if ((object3 = (Item)this.fields.get(object)) == null) {
                    object3 = new Item();
                    this.fields.put(object, object3);
                }
                if (pdfDictionary4 == null) {
                    ((Item)object3).addValue((PdfDictionary)pdfObject);
                } else {
                    ((Item)object3).addValue(pdfDictionary4);
                }
                ((Item)object3).addWidget((PdfDictionary)pdfObject);
                ((Item)object3).addWidgetRef(((PdfArray)pdfObject2).getAsIndirectObject(j));
                if (pdfDictionary2 != null) {
                    ((PdfDictionary)object2).mergeDifferent(pdfDictionary2);
                }
                ((Item)object3).addMerged((PdfDictionary)object2);
                ((Item)object3).addPage(i);
                ((Item)object3).addTabOrder(j);
            }
        }
        PdfNumber pdfNumber = pdfDictionary2.getAsNumber(PdfName.SIGFLAGS);
        if (pdfNumber == null || (pdfNumber.intValue() & 1) != 1) {
            return;
        }
        for (int i = 0; i < pdfArray.size(); ++i) {
            pdfObject2 = pdfArray.getAsDict(i);
            if (pdfObject2 == null) {
                PdfReader.releaseLastXrefPartial(pdfArray.getAsIndirectObject(i));
                continue;
            }
            if (!PdfName.WIDGET.equals(((PdfDictionary)pdfObject2).getAsName(PdfName.SUBTYPE))) {
                PdfReader.releaseLastXrefPartial(pdfArray.getAsIndirectObject(i));
                continue;
            }
            PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject2).get(PdfName.KIDS));
            if (pdfArray2 != null) continue;
            pdfDictionary = new PdfDictionary();
            pdfDictionary.putAll((PdfDictionary)pdfObject2);
            pdfObject = ((PdfDictionary)pdfObject2).getAsString(PdfName.T);
            if (pdfObject == null || this.fields.containsKey(object2 = ((PdfString)pdfObject).toUnicodeString())) continue;
            object = new Item();
            this.fields.put(object2, object);
            ((Item)object).addValue(pdfDictionary);
            ((Item)object).addWidget(pdfDictionary);
            ((Item)object).addWidgetRef(pdfArray.getAsIndirectObject(i));
            ((Item)object).addMerged(pdfDictionary);
            ((Item)object).addPage(-1);
            ((Item)object).addTabOrder(-1);
        }
    }

    static {
        stdFieldFontNames.put("CoBO", new String[]{"Courier-BoldOblique"});
        stdFieldFontNames.put("CoBo", new String[]{"Courier-Bold"});
        stdFieldFontNames.put("CoOb", new String[]{"Courier-Oblique"});
        stdFieldFontNames.put("Cour", new String[]{"Courier"});
        stdFieldFontNames.put("HeBO", new String[]{"Helvetica-BoldOblique"});
        stdFieldFontNames.put("HeBo", new String[]{"Helvetica-Bold"});
        stdFieldFontNames.put("HeOb", new String[]{"Helvetica-Oblique"});
        stdFieldFontNames.put("Helv", new String[]{"Helvetica"});
        stdFieldFontNames.put("Symb", new String[]{"Symbol"});
        stdFieldFontNames.put("TiBI", new String[]{"Times-BoldItalic"});
        stdFieldFontNames.put("TiBo", new String[]{"Times-Bold"});
        stdFieldFontNames.put("TiIt", new String[]{"Times-Italic"});
        stdFieldFontNames.put("TiRo", new String[]{"Times-Roman"});
        stdFieldFontNames.put("ZaDb", new String[]{"ZapfDingbats"});
        stdFieldFontNames.put("HySm", new String[]{"HYSMyeongJo-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("HyGo", new String[]{"HYGoThic-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaGo", new String[]{"HeiseiKakuGo-W5", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaMi", new String[]{"HeiseiMin-W3", "UniJIS-UCS2-H"});
        stdFieldFontNames.put("MHei", new String[]{"MHei-Medium", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("MSun", new String[]{"MSung-Light", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("STSo", new String[]{"STSong-Light", "UniGB-UCS2-H"});
        buttonRemove = new PdfName[]{PdfName.MK, PdfName.F, PdfName.FF, PdfName.Q, PdfName.BS, PdfName.BORDER};
    }

    public static class Item {
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList widget_refs = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
        public ArrayList tabOrder = new ArrayList();

        void addValue(PdfDictionary pdfDictionary) {
            this.values.add(pdfDictionary);
        }

        void addWidget(PdfDictionary pdfDictionary) {
            this.widgets.add(pdfDictionary);
        }

        void addWidgetRef(PdfIndirectReference pdfIndirectReference) {
            this.widget_refs.add(pdfIndirectReference);
        }

        void addMerged(PdfDictionary pdfDictionary) {
            this.merged.add(pdfDictionary);
        }

        void addPage(int n) {
            this.page.add(new Integer(n));
        }

        void addTabOrder(int n) {
            this.tabOrder.add(new Integer(n));
        }
    }
}

