/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;

public class DocumentFont
extends BaseFont {
    private HashMap metrics;
    private String fontName;
    private PRIndirectReference refFont;
    private IntHashtable uni2byte;
    private float Ascender;
    private float CapHeight;
    private float Descender;
    private float ItalicAngle;
    private float llx;
    private float lly;
    private float urx;
    private float ury;
    private boolean isType0;
    private BaseFont cjkMirror;
    private static String[] cjkNames = new String[]{"HeiseiMin-W3", "HeiseiKakuGo-W5", "STSong-Light", "MHei-Medium", "MSung-Light", "HYGoThic-Medium", "HYSMyeongJo-Medium", "MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    private static String[] cjkEncs = new String[]{"UniJIS-UCS2-H", "UniJIS-UCS2-H", "UniGB-UCS2-H", "UniCNS-UCS2-H", "UniCNS-UCS2-H", "UniKS-UCS2-H", "UniKS-UCS2-H", "UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H"};
    private static String[] cjkNames2 = new String[]{"MSungStd-Light", "STSongStd-Light", "HYSMyeongJoStd-Medium", "KozMinPro-Regular"};
    private static String[] cjkEncs2 = new String[]{"UniCNS-UCS2-H", "UniGB-UCS2-H", "UniKS-UCS2-H", "UniJIS-UCS2-H", "UniCNS-UTF16-H", "UniGB-UTF16-H", "UniKS-UTF16-H", "UniJIS-UTF16-H"};
    private static final int[] stdEnc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 33, 34, 35, 36, 37, 38, 8217, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 8216, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 162, 163, 8260, 165, 402, 167, 164, 39, 8220, 171, 8249, 8250, 64257, 64258, 0, 8211, 8224, 8225, 183, 0, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 0, 191, 0, 96, 180, 710, 732, 175, 728, 729, 168, 0, 730, 184, 0, 733, 731, 711, 8212, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 0, 170, 0, 0, 0, 0, 321, 216, 338, 186, 0, 0, 0, 0, 0, 230, 0, 0, 0, 305, 0, 0, 322, 248, 339, 223, 0, 0, 0, 0};

    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    public float getFontDescriptor(int n, float f) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getFontDescriptor(n, f);
        }
        switch (n) {
            case 1: 
            case 9: {
                return this.Ascender * f / 1000.0f;
            }
            case 2: {
                return this.CapHeight * f / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.Descender * f / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return this.llx * f / 1000.0f;
            }
            case 6: {
                return this.lly * f / 1000.0f;
            }
            case 7: {
                return this.urx * f / 1000.0f;
            }
            case 8: {
                return this.ury * f / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (this.urx - this.llx) * f / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.fontName}};
    }

    public int getKerning(int n, int n2) {
        return 0;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    int getRawWidth(int n, String string) {
        return 0;
    }

    public boolean hasKernPairs() {
        return false;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
    }

    public int getWidth(int n) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(n);
        }
        if (this.isType0) {
            int[] nArray = (int[])this.metrics.get(new Integer(n));
            if (nArray != null) {
                return nArray[1];
            }
            return 0;
        }
        return super.getWidth(n);
    }

    public int getWidth(String string) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(string);
        }
        if (this.isType0) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int[] nArray = (int[])this.metrics.get(new Integer(cArray[i]));
                if (nArray == null) continue;
                n2 += nArray[1];
            }
            return n2;
        }
        return super.getWidth(string);
    }

    byte[] convertToBytes(String string) {
        if (this.cjkMirror != null) {
            return PdfEncodings.convertToBytes(string, "UnicodeBigUnmarked");
        }
        if (this.isType0) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n * 2];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int[] nArray = (int[])this.metrics.get(new Integer(cArray[i]));
                if (nArray == null) continue;
                int n3 = nArray[0];
                byArray[n2++] = (byte)(n3 / 256);
                byArray[n2++] = (byte)n3;
            }
            if (n2 == byArray.length) {
                return byArray;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (!this.uni2byte.containsKey(cArray[i])) continue;
            byArray[n++] = (byte)this.uni2byte.get(cArray[i]);
        }
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        return byArray3;
    }

    byte[] convertToBytes(int n) {
        if (this.cjkMirror != null) {
            return PdfEncodings.convertToBytes((char)n, "UnicodeBigUnmarked");
        }
        if (this.isType0) {
            int[] nArray = (int[])this.metrics.get(new Integer(n));
            if (nArray != null) {
                int n2 = nArray[0];
                return new byte[]{(byte)(n2 / 256), (byte)n2};
            }
            return new byte[0];
        }
        if (this.uni2byte.containsKey(n)) {
            return new byte[]{(byte)this.uni2byte.get(n)};
        }
        return new byte[0];
    }

    PdfIndirectReference getIndirectReference() {
        return this.refFont;
    }

    protected int[] getRawCharBBox(int n, String string) {
        return null;
    }
}

