/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.util.HashMap;

public class PdfAcroForm
extends PdfDictionary {
    private PdfWriter writer;
    private HashMap fieldTemplates = new HashMap();
    private PdfArray documentFields = new PdfArray();
    private PdfArray calculationOrder = new PdfArray();
    private int sigFlags = 0;

    public PdfAcroForm(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    public void addFieldTemplates(HashMap hashMap) {
        this.fieldTemplates.putAll(hashMap);
    }

    public void addDocumentField(PdfIndirectReference pdfIndirectReference) {
        this.documentFields.add(pdfIndirectReference);
    }

    public boolean isValid() {
        if (this.documentFields.size() == 0) {
            return false;
        }
        this.put(PdfName.FIELDS, this.documentFields);
        if (this.sigFlags != 0) {
            this.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
        }
        if (this.calculationOrder.size() > 0) {
            this.put(PdfName.CO, this.calculationOrder);
        }
        if (this.fieldTemplates.isEmpty()) {
            return true;
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        Object object = this.fieldTemplates.keySet().iterator();
        while (object.hasNext()) {
            PdfTemplate pdfTemplate = (PdfTemplate)object.next();
            PdfFormField.mergeResources(pdfDictionary, (PdfDictionary)pdfTemplate.getResources());
        }
        this.put(PdfName.DR, pdfDictionary);
        this.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        object = (PdfDictionary)pdfDictionary.get(PdfName.FONT);
        if (object != null) {
            this.writer.eliminateFontSubset((PdfDictionary)object);
        }
        return true;
    }

    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.calculationOrder.add(pdfFormField.getIndirectReference());
    }

    public void setSigFlags(int n) {
        this.sigFlags |= n;
    }
}

