/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XfaForm {
    private Xml2SomTemplate templateSom;
    private Node templateNode;
    private Xml2SomDatasets datasetsSom;
    private Node datasetsNode;
    private PdfReader reader;
    private boolean xfaPresent;
    private Document domDocument;

    public XfaForm() {
    }

    public static PdfObject getXfaObject(PdfReader pdfReader) {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfReader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary == null) {
            return null;
        }
        return PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.XFA));
    }

    public XfaForm(PdfReader pdfReader) throws IOException, ParserConfigurationException, SAXException {
        Object object;
        this.reader = pdfReader;
        PdfObject pdfObject = XfaForm.getXfaObject(pdfReader);
        if (pdfObject == null) {
            this.xfaPresent = false;
            return;
        }
        this.xfaPresent = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (pdfObject.isArray()) {
            object = (PdfArray)pdfObject;
            for (int i = 1; i < ((PdfArray)object).size(); i += 2) {
                PdfObject pdfObject2 = ((PdfArray)object).getDirectObject(i);
                if (!(pdfObject2 instanceof PRStream)) continue;
                byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject2);
                byteArrayOutputStream.write(byArray);
            }
        } else if (pdfObject instanceof PRStream) {
            object = PdfReader.getStreamBytes((PRStream)pdfObject);
            byteArrayOutputStream.write((byte[])object);
        }
        byteArrayOutputStream.close();
        object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setNamespaceAware(true);
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        this.domDocument = documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        this.extractNodes();
    }

    private void extractNodes() {
        Node node = this.domDocument.getFirstChild();
        while (node.getChildNodes().getLength() == 0) {
            node = node.getNextSibling();
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String string = node.getLocalName();
            if (string.equals("template")) {
                this.templateNode = node;
                this.templateSom = new Xml2SomTemplate(node);
                continue;
            }
            if (!string.equals("datasets")) continue;
            this.datasetsNode = node;
            this.datasetsSom = new Xml2SomDatasets(node.getFirstChild());
        }
    }

    public static class Xml2SomTemplate
    extends Xml2Som {
        private boolean dynamicForm;
        private int templateLevel;

        public Xml2SomTemplate(Node node) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.templateLevel = 0;
            this.inverseSearch = new HashMap();
            this.processTemplate(node, null);
        }

        private void processTemplate(Node node, HashMap hashMap) {
            if (hashMap == null) {
                hashMap = new HashMap<String, Integer>();
            }
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Object object;
                if (node2.getNodeType() != 1) continue;
                String string = node2.getLocalName();
                if (string.equals("subform")) {
                    Node node3 = node2.getAttributes().getNamedItem("name");
                    String string2 = "#subform";
                    boolean bl = true;
                    if (node3 != null) {
                        string2 = Xml2SomTemplate.escapeSom(node3.getNodeValue());
                        bl = false;
                    }
                    if (bl) {
                        object = new Integer(this.anform);
                        ++this.anform;
                    } else {
                        object = (Integer)hashMap2.get(string2);
                        object = object == null ? new Integer(0) : new Integer((Integer)object + 1);
                        hashMap2.put(string2, (Integer)object);
                    }
                    this.stack.push(string2 + "[" + ((Integer)object).toString() + "]");
                    ++this.templateLevel;
                    if (bl) {
                        this.processTemplate(node2, hashMap);
                    } else {
                        this.processTemplate(node2, null);
                    }
                    --this.templateLevel;
                    this.stack.pop();
                    continue;
                }
                if (string.equals("field") || string.equals("exclGroup")) {
                    Node node4 = node2.getAttributes().getNamedItem("name");
                    if (node4 == null) continue;
                    String string3 = Xml2SomTemplate.escapeSom(node4.getNodeValue());
                    Integer n = (Integer)hashMap.get(string3);
                    n = n == null ? new Integer(0) : new Integer(n + 1);
                    hashMap.put(string3, n);
                    this.stack.push(string3 + "[" + n.toString() + "]");
                    object = this.printStack();
                    this.order.add(object);
                    this.inverseSearchAdd((String)object);
                    this.name2Node.put(object, node2);
                    this.stack.pop();
                    continue;
                }
                if (this.dynamicForm || this.templateLevel <= 0 || !string.equals("occur")) continue;
                int n = 1;
                int n2 = 1;
                int n3 = 1;
                object = node2.getAttributes().getNamedItem("initial");
                if (object != null) {
                    try {
                        n = Integer.parseInt(object.getNodeValue().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((object = node2.getAttributes().getNamedItem("min")) != null) {
                    try {
                        n2 = Integer.parseInt(object.getNodeValue().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((object = node2.getAttributes().getNamedItem("max")) != null) {
                    try {
                        n3 = Integer.parseInt(object.getNodeValue().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n == n2 && n2 == n3) continue;
                this.dynamicForm = true;
            }
        }
    }

    public static class Xml2SomDatasets
    extends Xml2Som {
        public Xml2SomDatasets(Node node) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.inverseSearch = new HashMap();
            this.processDatasetsInternal(node);
        }

        private static boolean hasChildren(Node node) {
            Object object;
            Node node2 = node.getAttributes().getNamedItemNS("http://www.xfa.org/schema/xfa-data/1.0/", "dataNode");
            if (node2 != null) {
                object = node2.getNodeValue();
                if ("dataGroup".equals(object)) {
                    return true;
                }
                if ("dataValue".equals(object)) {
                    return false;
                }
            }
            if (!node.hasChildNodes()) {
                return false;
            }
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1) continue;
                return true;
            }
            return false;
        }

        private void processDatasetsInternal(Node node) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1) continue;
                String string = Xml2SomDatasets.escapeSom(node2.getLocalName());
                Integer n = (Integer)hashMap.get(string);
                n = n == null ? new Integer(0) : new Integer(n + 1);
                hashMap.put(string, n);
                if (Xml2SomDatasets.hasChildren(node2)) {
                    this.stack.push(string + "[" + n.toString() + "]");
                    this.processDatasetsInternal(node2);
                    this.stack.pop();
                    continue;
                }
                this.stack.push(string + "[" + n.toString() + "]");
                String string2 = this.printStack();
                this.order.add(string2);
                this.inverseSearchAdd(string2);
                this.name2Node.put(string2, node2);
                this.stack.pop();
            }
        }
    }

    public static class Xml2Som {
        protected ArrayList order;
        protected HashMap name2Node;
        protected HashMap inverseSearch;
        protected Stack2 stack;
        protected int anform;

        public static String escapeSom(String string) {
            int n = string.indexOf(46);
            if (n < 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n >= 0) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append('\\');
                n2 = n;
                n = string.indexOf(46, n + 1);
            }
            stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }

        protected String printStack() {
            if (this.stack.empty()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.stack.size(); ++i) {
                stringBuffer.append('.').append((String)this.stack.get(i));
            }
            return stringBuffer.substring(1);
        }

        public void inverseSearchAdd(String string) {
            Xml2Som.inverseSearchAdd(this.inverseSearch, this.stack, string);
        }

        public static void inverseSearchAdd(HashMap hashMap, Stack2 stack2, String string) {
            String string2 = (String)stack2.peek();
            InverseStore inverseStore = (InverseStore)hashMap.get(string2);
            if (inverseStore == null) {
                inverseStore = new InverseStore();
                hashMap.put(string2, inverseStore);
            }
            for (int i = stack2.size() - 2; i >= 0; --i) {
                InverseStore inverseStore2;
                string2 = (String)stack2.get(i);
                int n = inverseStore.part.indexOf(string2);
                if (n < 0) {
                    inverseStore.part.add(string2);
                    inverseStore2 = new InverseStore();
                    inverseStore.follow.add(inverseStore2);
                } else {
                    inverseStore2 = (InverseStore)inverseStore.follow.get(n);
                }
                inverseStore = inverseStore2;
            }
            inverseStore.part.add("");
            inverseStore.follow.add(string);
        }
    }

    public static class Stack2
    extends ArrayList {
        public Object peek() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            return this.get(this.size() - 1);
        }

        public Object pop() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            Object e = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            return e;
        }

        public Object push(Object object) {
            this.add(object);
            return object;
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }

    public static class InverseStore {
        protected ArrayList part = new ArrayList();
        protected ArrayList follow = new ArrayList();
    }
}

