/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml.xmp;

import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.xml.xmp.DublinCoreSchema;
import com.lowagie.text.xml.xmp.PdfA1Schema;
import com.lowagie.text.xml.xmp.PdfSchema;
import com.lowagie.text.xml.xmp.XmpBasicSchema;
import com.lowagie.text.xml.xmp.XmpSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class XmpWriter {
    protected int extraSpace;
    protected OutputStreamWriter writer;
    protected String about;
    protected char end = (char)119;

    public XmpWriter(OutputStream outputStream, String string, int n) throws IOException {
        this.extraSpace = n;
        this.writer = new OutputStreamWriter(outputStream, string);
        this.writer.write("<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n");
        this.writer.write("<x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n");
        this.writer.write("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        this.about = "";
    }

    public XmpWriter(OutputStream outputStream) throws IOException {
        this(outputStream, "UTF-8", 20);
    }

    public void addRdfDescription(XmpSchema xmpSchema) throws IOException {
        this.writer.write("<rdf:Description rdf:about=\"");
        this.writer.write(this.about);
        this.writer.write("\" ");
        this.writer.write(xmpSchema.getXmlns());
        this.writer.write(">");
        this.writer.write(xmpSchema.toString());
        this.writer.write("</rdf:Description>\n");
    }

    public void close() throws IOException {
        this.writer.write("</rdf:RDF>");
        this.writer.write("</x:xmpmeta>\n");
        for (int i = 0; i < this.extraSpace; ++i) {
            this.writer.write("                                                                                                   \n");
        }
        this.writer.write(this.end == 'r' ? "<?xpacket end=\"r\"?>" : "<?xpacket end=\"w\"?>");
        this.writer.flush();
        this.writer.close();
    }

    public XmpWriter(OutputStream outputStream, PdfDictionary pdfDictionary, int n) throws IOException {
        this(outputStream);
        if (pdfDictionary != null) {
            DublinCoreSchema dublinCoreSchema = new DublinCoreSchema();
            PdfSchema pdfSchema = new PdfSchema();
            XmpBasicSchema xmpBasicSchema = new XmpBasicSchema();
            Object object = pdfDictionary.getKeys().iterator();
            while (object.hasNext()) {
                PdfName pdfName = (PdfName)object.next();
                PdfObject pdfObject = pdfDictionary.get(pdfName);
                if (pdfObject == null) continue;
                if (PdfName.TITLE.equals(pdfName)) {
                    dublinCoreSchema.addTitle(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.AUTHOR.equals(pdfName)) {
                    dublinCoreSchema.addAuthor(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.SUBJECT.equals(pdfName)) {
                    dublinCoreSchema.addSubject(((PdfString)pdfObject).toUnicodeString());
                    dublinCoreSchema.addDescription(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.KEYWORDS.equals(pdfName)) {
                    pdfSchema.addKeywords(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.CREATOR.equals(pdfName)) {
                    xmpBasicSchema.addCreatorTool(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.PRODUCER.equals(pdfName)) {
                    pdfSchema.addProducer(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.CREATIONDATE.equals(pdfName)) {
                    xmpBasicSchema.addCreateDate(((PdfDate)pdfObject).getW3CDate());
                }
                if (!PdfName.MODDATE.equals(pdfName)) continue;
                xmpBasicSchema.addModDate(((PdfDate)pdfObject).getW3CDate());
            }
            if (dublinCoreSchema.size() > 0) {
                this.addRdfDescription(dublinCoreSchema);
            }
            if (pdfSchema.size() > 0) {
                this.addRdfDescription(pdfSchema);
            }
            if (xmpBasicSchema.size() > 0) {
                this.addRdfDescription(xmpBasicSchema);
            }
            if (n == 3 || n == 4) {
                object = new PdfA1Schema();
                if (n == 3) {
                    ((PdfA1Schema)object).addConformance("A");
                } else {
                    ((PdfA1Schema)object).addConformance("B");
                }
                this.addRdfDescription((XmpSchema)object);
            }
        }
    }
}

