/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TtScaler {
    private final double fixOffset_;
    private final double scaleBase_;
    private final double scaleFactor_;
    private final long fromTt2kMillis_;
    private final long toTt2kMillis_;
    private static final double MILLIS_PER_DAY = 8.64E7;
    private static final double J2000_MJD = 51544.5;
    private static final double UNIXEPOCH_MJD = 40587.0;
    private static final double TT_TAI_MILLIS = 32184.0;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final double J2000_UNIXMILLIS = 9.46728E11;
    public static final String LEAP_FILE_ENV = "CDF_LEAPSECONDSTABLE";
    private static final Logger logger_ = Logger.getLogger(TtScaler.class.getName());
    private static final double[][] LTS = new double[][]{{1960.0, 1.0, 1.0, 1.417818, 37300.0, 0.001296}, {1961.0, 1.0, 1.0, 1.422818, 37300.0, 0.001296}, {1961.0, 8.0, 1.0, 1.372818, 37300.0, 0.001296}, {1962.0, 1.0, 1.0, 1.845858, 37665.0, 0.0011232}, {1963.0, 11.0, 1.0, 1.945858, 37665.0, 0.0011232}, {1964.0, 1.0, 1.0, 3.24013, 38761.0, 0.001296}, {1964.0, 4.0, 1.0, 3.34013, 38761.0, 0.001296}, {1964.0, 9.0, 1.0, 3.44013, 38761.0, 0.001296}, {1965.0, 1.0, 1.0, 3.54013, 38761.0, 0.001296}, {1965.0, 3.0, 1.0, 3.64013, 38761.0, 0.001296}, {1965.0, 7.0, 1.0, 3.74013, 38761.0, 0.001296}, {1965.0, 9.0, 1.0, 3.84013, 38761.0, 0.001296}, {1966.0, 1.0, 1.0, 4.31317, 39126.0, 0.002592}, {1968.0, 2.0, 1.0, 4.21317, 39126.0, 0.002592}, {1972.0, 1.0, 1.0, 10.0, 0.0, 0.0}, {1972.0, 7.0, 1.0, 11.0, 0.0, 0.0}, {1973.0, 1.0, 1.0, 12.0, 0.0, 0.0}, {1974.0, 1.0, 1.0, 13.0, 0.0, 0.0}, {1975.0, 1.0, 1.0, 14.0, 0.0, 0.0}, {1976.0, 1.0, 1.0, 15.0, 0.0, 0.0}, {1977.0, 1.0, 1.0, 16.0, 0.0, 0.0}, {1978.0, 1.0, 1.0, 17.0, 0.0, 0.0}, {1979.0, 1.0, 1.0, 18.0, 0.0, 0.0}, {1980.0, 1.0, 1.0, 19.0, 0.0, 0.0}, {1981.0, 7.0, 1.0, 20.0, 0.0, 0.0}, {1982.0, 7.0, 1.0, 21.0, 0.0, 0.0}, {1983.0, 7.0, 1.0, 22.0, 0.0, 0.0}, {1985.0, 7.0, 1.0, 23.0, 0.0, 0.0}, {1988.0, 1.0, 1.0, 24.0, 0.0, 0.0}, {1990.0, 1.0, 1.0, 25.0, 0.0, 0.0}, {1991.0, 1.0, 1.0, 26.0, 0.0, 0.0}, {1992.0, 7.0, 1.0, 27.0, 0.0, 0.0}, {1993.0, 7.0, 1.0, 28.0, 0.0, 0.0}, {1994.0, 7.0, 1.0, 29.0, 0.0, 0.0}, {1996.0, 1.0, 1.0, 30.0, 0.0, 0.0}, {1997.0, 7.0, 1.0, 31.0, 0.0, 0.0}, {1999.0, 1.0, 1.0, 32.0, 0.0, 0.0}, {2006.0, 1.0, 1.0, 33.0, 0.0, 0.0}, {2009.0, 1.0, 1.0, 34.0, 0.0, 0.0}, {2012.0, 7.0, 1.0, 35.0, 0.0, 0.0}, {2015.0, 7.0, 1.0, 36.0, 0.0, 0.0}, {2017.0, 1.0, 1.0, 37.0, 0.0, 0.0}};
    private static TtScaler[] ORDERED_INSTANCES;

    public TtScaler(double d, double d2, double d3, long l, long l2) {
        this.fixOffset_ = d;
        this.scaleBase_ = d2;
        this.scaleFactor_ = d3;
        this.fromTt2kMillis_ = l;
        this.toTt2kMillis_ = l2;
    }

    public double tt2kToUnixMillis(long l) {
        return TtScaler.tt2kToUnixMillis(l, this.fixOffset_, this.scaleBase_, this.scaleFactor_);
    }

    public long getFromTt2kMillis() {
        return this.fromTt2kMillis_;
    }

    public long getToTt2kMillis() {
        return this.toTt2kMillis_;
    }

    public int compareTt2kMillis(long l) {
        if (l < this.fromTt2kMillis_) {
            return -1;
        }
        if (l >= this.toTt2kMillis_) {
            return 1;
        }
        return 0;
    }

    public abstract int millisIntoLeapSecond(long var1);

    public static int getScalerIndex(long l, TtScaler[] ttScalerArray, int n) {
        int n2 = ttScalerArray.length;
        return TtScaler.scalerBinarySearch(l, ttScalerArray, n >= 0 ? n : n2 / 2, 0, n2 - 1);
    }

    private static int scalerBinarySearch(long l, TtScaler[] ttScalerArray, int n, int n2, int n3) {
        int n4 = ttScalerArray[n].compareTt2kMillis(l);
        if (n4 == 0) {
            return n;
        }
        if (n < n2 || n > n3) {
            return -1;
        }
        assert (n >= n2 && n <= n3);
        if (n4 < 0) {
            return TtScaler.scalerBinarySearch(l, ttScalerArray, n - (n - n2 + 1) / 2, n2, n - 1);
        }
        assert (n4 > 0);
        return TtScaler.scalerBinarySearch(l, ttScalerArray, n + (n3 - n + 1) / 2, n + 1, n3);
    }

    private static double tt2kToUnixMillis(long l, double d, double d2, double d3) {
        double d4 = (double)l / 8.64E7 + 51544.5;
        double d5 = d + (d4 - d2) * d3;
        double d6 = d5 * 1000.0;
        return (double)l - 32184.0 - d6 + 9.46728E11;
    }

    private static double unixToTt2kMillis(long l, double d, double d2, double d3) {
        double d4 = (double)l / 8.64E7 + 40587.0;
        double d5 = d + (d4 - d2) * d3;
        double d6 = d5 * 1000.0;
        return (double)l + 32184.0 + d6 - 9.46728E11;
    }

    public static synchronized TtScaler[] getTtScalers() {
        if (ORDERED_INSTANCES == null) {
            ORDERED_INSTANCES = TtScaler.createTtScalers();
        }
        return (TtScaler[])ORDERED_INSTANCES.clone();
    }

    private static TtScaler[] createTtScalers() {
        LtEntry[] ltEntryArray = TtScaler.readLtEntries();
        int n = ltEntryArray.length;
        logger_.config("CDF Leap second table: " + ltEntryArray.length + " entries, " + "last is " + ltEntryArray[n - 1]);
        ArrayList<TtScaler> arrayList = new ArrayList<TtScaler>();
        LtEntry ltEntry = ltEntryArray[0];
        arrayList.add(new NoLeapTtScaler(0.0, 0.0, 0.0, Long.MIN_VALUE, ltEntry.getDateTt2kMillis()));
        for (int i = 0; i < n - 1; ++i) {
            LtEntry ltEntry2 = ltEntryArray[i];
            LtEntry ltEntry3 = ltEntryArray[i + 1];
            long l = ltEntry2.getDateTt2kMillis();
            long l2 = ltEntry3.getDateTt2kMillis();
            if (ltEntry3.hasPrecedingLeapSecond()) {
                arrayList.add(new NoLeapTtScaler(ltEntry2, l, l2 - 1000L));
                arrayList.add(new LeapDurationTtScaler(ltEntry2, l2 - 1000L));
                continue;
            }
            arrayList.add(new NoLeapTtScaler(ltEntry2, l, l2));
        }
        LtEntry ltEntry4 = ltEntryArray[n - 1];
        arrayList.add(new NoLeapTtScaler(ltEntry4, ltEntry4.getDateTt2kMillis(), Long.MAX_VALUE));
        return arrayList.toArray(new TtScaler[0]);
    }

    private static LtEntry[] readLtEntries() {
        LtEntry[] ltEntryArray = null;
        try {
            ltEntryArray = TtScaler.readLtEntriesFile();
        }
        catch (IOException iOException) {
            logger_.log(Level.WARNING, "Failed to read external leap seconds file: " + iOException, iOException);
        }
        catch (RuntimeException runtimeException) {
            logger_.log(Level.WARNING, "Failed to read external leap seconds file: " + runtimeException, runtimeException);
        }
        if (ltEntryArray != null) {
            return ltEntryArray;
        }
        logger_.config("Using internal leap seconds table");
        int n = LTS.length;
        LtEntry[] ltEntryArray2 = new LtEntry[n];
        for (int i = 0; i < n; ++i) {
            ltEntryArray2[i] = new LtEntry(LTS[i]);
        }
        return ltEntryArray2;
    }

    private static LtEntry[] readLtEntriesFile() throws IOException {
        String string;
        String string2;
        try {
            string2 = System.getenv(LEAP_FILE_ENV);
        }
        catch (SecurityException securityException) {
            logger_.config("Can't access external leap seconds file: " + securityException);
            return null;
        }
        if (string2 == null) {
            return null;
        }
        logger_.config("Reading leap seconds from file " + string2);
        File file = new File(string2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<LtEntry> arrayList = new ArrayList<LtEntry>();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith(";")) continue;
            String[] stringArray = string.trim().split("\\s+");
            if (stringArray.length != 6) {
                throw new IOException("Bad leap second file format - got " + stringArray.length + " fields not 6" + " at line \"" + string + "\"");
            }
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                double d = Double.parseDouble(stringArray[3]);
                double d2 = Double.parseDouble(stringArray[4]);
                double d3 = Double.parseDouble(stringArray[5]);
                arrayList.add(new LtEntry(n, n2, n3, d, d2, d3));
            }
            catch (NumberFormatException numberFormatException) {
                throw (IOException)new IOException("Bad entry in leap seconds file").initCause(numberFormatException);
            }
        }
        return arrayList.toArray(new LtEntry[0]);
    }

    private static class LtEntry {
        final int year_;
        final int month_;
        final int dom_;
        final double fixOffset_;
        final double scaleBase_;
        final double scaleFactor_;

        public LtEntry(int n, int n2, int n3, double d, double d2, double d3) {
            this.year_ = n;
            this.month_ = n2;
            this.dom_ = n3;
            this.fixOffset_ = d;
            this.scaleBase_ = d2;
            this.scaleFactor_ = d3;
        }

        public LtEntry(double[] dArray) {
            this((int)dArray[0], (int)dArray[1], (int)dArray[2], dArray[3], dArray[4], dArray[5]);
            assert ((double)this.year_ == dArray[0]);
            assert ((double)this.month_ == dArray[1]);
            assert ((double)this.dom_ == dArray[2]);
        }

        public long getDateTt2kMillis() {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(UTC, Locale.UK);
            gregorianCalendar.clear();
            gregorianCalendar.set(this.year_, this.month_ - 1, this.dom_);
            long l = gregorianCalendar.getTimeInMillis();
            return (long)TtScaler.unixToTt2kMillis(l, this.fixOffset_, this.scaleBase_, this.scaleFactor_);
        }

        public boolean hasPrecedingLeapSecond() {
            return this.scaleFactor_ == 0.0;
        }

        public String toString() {
            return this.year_ + "-" + this.month_ + "-" + this.dom_ + ": " + this.fixOffset_ + ", " + this.scaleBase_ + ", " + this.scaleFactor_;
        }
    }

    private static class LeapDurationTtScaler
    extends TtScaler {
        private final long leapStartTt2kMillis_;

        LeapDurationTtScaler(LtEntry ltEntry, long l) {
            super(ltEntry.fixOffset_, ltEntry.scaleBase_, ltEntry.scaleFactor_, l, l + 1000L);
            this.leapStartTt2kMillis_ = l;
        }

        public int millisIntoLeapSecond(long l) {
            long l2 = l - this.leapStartTt2kMillis_;
            return l2 >= 0L && l2 <= 1000L ? (int)l2 : -1;
        }
    }

    private static class NoLeapTtScaler
    extends TtScaler {
        NoLeapTtScaler(double d, double d2, double d3, long l, long l2) {
            super(d, d2, d3, l, l2);
        }

        NoLeapTtScaler(LtEntry ltEntry, long l, long l2) {
            this(ltEntry.fixOffset_, ltEntry.scaleBase_, ltEntry.scaleFactor_, l, l2);
        }

        public int millisIntoLeapSecond(long l) {
            return -1;
        }
    }
}

