/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.IOException;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.CdfField;
import uk.ac.bristol.star.cdf.record.OffsetField;
import uk.ac.bristol.star.cdf.record.Pointer;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordPlan;

public abstract class AttributeEntryDescriptorRecord
extends Record {
    @CdfField
    @OffsetField
    public final long aedrNext;
    @CdfField
    public final int attrNum;
    @CdfField
    public final int dataType;
    @CdfField
    public final int num;
    @CdfField
    public final int numElems;
    @CdfField
    public final int rfuA;
    @CdfField
    public final int rfuB;
    @CdfField
    public final int rfuC;
    @CdfField
    public final int rfuD;
    @CdfField
    public final int rfuE;
    private final long valueOffset_;

    private AttributeEntryDescriptorRecord(RecordPlan recordPlan, String string, int n) throws IOException {
        super(recordPlan, string, n);
        Buf buf = recordPlan.getBuf();
        Pointer pointer = recordPlan.createContentPointer();
        this.aedrNext = buf.readOffset(pointer);
        this.attrNum = buf.readInt(pointer);
        this.dataType = buf.readInt(pointer);
        this.num = buf.readInt(pointer);
        this.numElems = buf.readInt(pointer);
        this.rfuA = this.checkIntValue(buf.readInt(pointer), 0);
        this.rfuB = this.checkIntValue(buf.readInt(pointer), 0);
        this.rfuC = this.checkIntValue(buf.readInt(pointer), 0);
        this.rfuD = this.checkIntValue(buf.readInt(pointer), -1);
        this.rfuE = this.checkIntValue(buf.readInt(pointer), -1);
        this.valueOffset_ = pointer.get();
    }

    public long getValueOffset() {
        return this.valueOffset_;
    }

    public static class ZVariant
    extends AttributeEntryDescriptorRecord {
        public ZVariant(RecordPlan recordPlan) throws IOException {
            super(recordPlan, "AzEDR", 9);
        }
    }

    public static class GrVariant
    extends AttributeEntryDescriptorRecord {
        public GrVariant(RecordPlan recordPlan) throws IOException {
            super(recordPlan, "AgrEDR", 5);
        }
    }
}

