/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Bufs;
import uk.ac.bristol.star.cdf.record.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BankBuf
implements Buf {
    private final long size_;
    private boolean isBit64_;
    private boolean isBigendian_;
    private static final Logger logger_ = Logger.getLogger(BankBuf.class.getName());

    protected BankBuf(long l, boolean bl, boolean bl2) {
        this.size_ = l;
        this.isBit64_ = bl;
        this.isBigendian_ = bl2;
    }

    protected abstract Bank getBank(long var1, int var3) throws IOException;

    protected abstract List<Bank> getExistingBanks();

    protected abstract Iterator<Bank> getBankIterator(long var1);

    @Override
    public long getLength() {
        return this.size_;
    }

    @Override
    public int readUnsignedByte(Pointer pointer) throws IOException {
        long l = pointer.getAndIncrement(1);
        Bank bank = this.getBank(l, 1);
        return bank.byteBuffer_.get(bank.adjust(l));
    }

    @Override
    public int readInt(Pointer pointer) throws IOException {
        long l = pointer.getAndIncrement(4);
        Bank bank = this.getBank(l, 4);
        return bank.byteBuffer_.getInt(bank.adjust(l));
    }

    @Override
    public long readOffset(Pointer pointer) throws IOException {
        int n = this.isBit64_ ? 8 : 4;
        long l = pointer.getAndIncrement(n);
        Bank bank = this.getBank(l, n);
        int n2 = bank.adjust(l);
        return this.isBit64_ ? bank.byteBuffer_.getLong(n2) : (long)bank.byteBuffer_.getInt(n2);
    }

    @Override
    public String readAsciiString(Pointer pointer, int n) throws IOException {
        long l = pointer.getAndIncrement(n);
        Bank bank = this.getBank(l, n);
        return Bufs.readAsciiString(bank.byteBuffer_, bank.adjust(l), n);
    }

    @Override
    public synchronized void setBit64(boolean bl) {
        this.isBit64_ = bl;
    }

    @Override
    public boolean isBit64() {
        return this.isBit64_;
    }

    @Override
    public synchronized void setEncoding(boolean bl) {
        this.isBigendian_ = bl;
        for (Bank bank : this.getExistingBanks()) {
            bank.setEncoding(this.isBigendian_);
        }
    }

    @Override
    public boolean isBigendian() {
        return this.isBigendian_;
    }

    @Override
    public void readDataBytes(long l, int n, byte[] byArray) throws IOException {
        Bank bank = this.getBank(l, n);
        Bufs.readBytes(bank.dataBuffer_, bank.adjust(l), n, byArray);
    }

    @Override
    public void readDataShorts(long l, int n, short[] sArray) throws IOException {
        Bank bank = this.getBank(l, n * 2);
        Bufs.readShorts(bank.dataBuffer_, bank.adjust(l), n, sArray);
    }

    @Override
    public void readDataInts(long l, int n, int[] nArray) throws IOException {
        Bank bank = this.getBank(l, n * 4);
        Bufs.readInts(bank.dataBuffer_, bank.adjust(l), n, nArray);
    }

    @Override
    public void readDataLongs(long l, int n, long[] lArray) throws IOException {
        Bank bank = this.getBank(l, n * 8);
        Bufs.readLongs(bank.dataBuffer_, bank.adjust(l), n, lArray);
    }

    @Override
    public void readDataFloats(long l, int n, float[] fArray) throws IOException {
        Bank bank = this.getBank(l, n * 4);
        Bufs.readFloats(bank.dataBuffer_, bank.adjust(l), n, fArray);
    }

    @Override
    public void readDataDoubles(long l, int n, double[] dArray) throws IOException {
        Bank bank = this.getBank(l, n * 8);
        Bufs.readDoubles(bank.dataBuffer_, bank.adjust(l), n, dArray);
    }

    @Override
    public InputStream createInputStream(final long l) {
        final Iterator<Bank> iterator = this.getBankIterator(l);
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){
            boolean isFirst = true;

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                Bank bank = (Bank)iterator.next();
                ByteBuffer byteBuffer = bank.byteBuffer_.duplicate();
                byteBuffer.position(this.isFirst ? bank.adjust(l) : 0);
                this.isFirst = false;
                return Bufs.createByteBufferInputStream(byteBuffer);
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    public Buf fillNewBuf(long l, InputStream inputStream) throws IOException {
        return l <= Integer.MAX_VALUE ? this.fillNewSingleBuf((int)l, inputStream) : this.fillNewMultiBuf(l, inputStream);
    }

    private Buf fillNewSingleBuf(int n, InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        while (n > 0) {
            int n2 = readableByteChannel.read(byteBuffer);
            if (n2 < 0) {
                throw new EOFException();
            }
            n -= n2;
        }
        return Bufs.createBuf(byteBuffer, this.isBit64_, this.isBigendian_);
    }

    private Buf fillNewMultiBuf(long l, InputStream inputStream) throws IOException {
        File file = File.createTempFile("cdfbuf", ".bin");
        file.deleteOnExit();
        int n = 65536;
        byte[] byArray = new byte[n];
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        while (l > 0L) {
            int n2 = inputStream.read(byArray);
            ((OutputStream)fileOutputStream).write(byArray, 0, n2);
            l -= (long)n2;
        }
        ((OutputStream)fileOutputStream).close();
        return Bufs.createBuf(file, this.isBit64_, this.isBigendian_);
    }

    public static BankBuf createSingleBankBuf(ByteBuffer byteBuffer, boolean bl, boolean bl2) {
        return new SingleBankBuf(byteBuffer, bl, bl2);
    }

    public static BankBuf createMultiBankBuf(ByteBuffer[] byteBufferArray, boolean bl, boolean bl2) {
        return new PreMultiBankBuf(byteBufferArray, bl, bl2);
    }

    public static BankBuf createMultiBankBuf(FileChannel fileChannel, long l, int n, boolean bl, boolean bl2) {
        return new LazyMultiBankBuf(fileChannel, l, n, bl, bl2);
    }

    protected static class Bank {
        private final ByteBuffer byteBuffer_;
        private final ByteBuffer dataBuffer_;
        private final long start_;
        private final int size_;

        public Bank(ByteBuffer byteBuffer, long l, boolean bl) {
            this.byteBuffer_ = byteBuffer;
            this.dataBuffer_ = byteBuffer.duplicate();
            this.start_ = l;
            this.size_ = byteBuffer.capacity();
            this.setEncoding(bl);
        }

        private int adjust(long l) {
            long l2 = l - this.start_;
            if (l2 >= 0L && l2 < (long)this.size_) {
                return (int)l2;
            }
            throw new IllegalArgumentException("Out of range: " + l + " for bank at " + this.start_);
        }

        private void setEncoding(boolean bl) {
            this.dataBuffer_.order(bl ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyMultiBankBuf
    extends BankBuf {
        private final FileChannel channel_;
        private final long size_;
        private final long bankSize_;
        private final Bank[] banks_;

        LazyMultiBankBuf(FileChannel fileChannel, long l, int n, boolean bl, boolean bl2) {
            super(l, bl, bl2);
            this.channel_ = fileChannel;
            this.size_ = l;
            this.bankSize_ = n;
            int n2 = (int)((l - 1L) / (long)n + 1L);
            this.banks_ = new Bank[n2];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bank getBank(long l, int n) throws IOException {
            int n2 = (int)(l / this.bankSize_);
            int n3 = (int)(l + (long)n - (long)(n2 + 1) * this.bankSize_);
            if (n3 <= 0) {
                return this.getBankByIndex(n2);
            }
            byte[] byArray = new byte[n];
            int n4 = n - n3;
            int n5 = 0;
            while (n > 0) {
                ByteBuffer byteBuffer;
                int n6 = (int)Math.min((long)n, (long)(n2 + 1) * this.bankSize_ - (long)n4);
                ByteBuffer byteBuffer2 = byteBuffer = this.getBankByIndex(n2).byteBuffer_;
                synchronized (byteBuffer2) {
                    byteBuffer.position(n4);
                    byteBuffer.get(byArray, n5, n6);
                }
                n -= n6;
                n5 += n6;
                n4 = 0;
                ++n2;
            }
            return new Bank(ByteBuffer.wrap(byArray), l, this.isBigendian());
        }

        @Override
        public List<Bank> getExistingBanks() {
            ArrayList<Bank> arrayList = new ArrayList<Bank>();
            for (int i = 0; i < this.banks_.length; ++i) {
                Bank bank = this.banks_[i];
                if (bank == null) continue;
                arrayList.add(bank);
            }
            return arrayList;
        }

        @Override
        public Iterator<Bank> getBankIterator(final long l) {
            return new Iterator<Bank>(){
                int ibank;
                {
                    this.ibank = (int)(l / LazyMultiBankBuf.this.bankSize_);
                }

                @Override
                public boolean hasNext() {
                    return this.ibank < LazyMultiBankBuf.this.banks_.length;
                }

                @Override
                public Bank next() {
                    try {
                        return LazyMultiBankBuf.this.getBankByIndex(this.ibank++);
                    }
                    catch (IOException iOException) {
                        logger_.log(Level.WARNING, "Error acquiring bank", iOException);
                        return null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private Bank getBankByIndex(int n) throws IOException {
            if (this.banks_[n] == null) {
                long l = (long)n * this.bankSize_;
                long l2 = Math.min((long)(n + 1) * this.bankSize_, this.size_);
                int n2 = (int)(l2 - l);
                MappedByteBuffer mappedByteBuffer = this.channel_.map(FileChannel.MapMode.READ_ONLY, l, n2);
                this.banks_[n] = new Bank(mappedByteBuffer, l, this.isBigendian());
            }
            return this.banks_[n];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PreMultiBankBuf
    extends BankBuf {
        private final Bank[] banks_;
        private final long[] starts_;
        private final long[] ends_;
        private int iCurrentBank_;

        PreMultiBankBuf(ByteBuffer[] byteBufferArray, boolean bl, boolean bl2) {
            super(PreMultiBankBuf.sumSizes(byteBufferArray), bl, bl2);
            int n = byteBufferArray.length;
            this.banks_ = new Bank[n];
            this.starts_ = new long[n];
            this.ends_ = new long[n];
            long l = 0L;
            for (int i = 0; i < n; ++i) {
                ByteBuffer byteBuffer = byteBufferArray[i];
                this.banks_[i] = new Bank(byteBuffer, l, bl2);
                this.starts_[i] = l;
                this.ends_[i] = l += (long)byteBuffer.capacity();
            }
            this.iCurrentBank_ = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Bank getBank(long l, int n) {
            int n2 = this.iCurrentBank_;
            if (l >= this.starts_[n2] && l + (long)n <= this.ends_[n2]) {
                return this.banks_[n2];
            }
            n2 = -1;
            for (int i = 0; i < this.banks_.length; ++i) {
                if (l < this.starts_[i] || l >= this.ends_[i]) continue;
                n2 = i;
                break;
            }
            this.iCurrentBank_ = n2;
            if (l + (long)n <= this.ends_[n2]) {
                return this.banks_[n2];
            }
            byte[] byArray = new byte[n];
            int n3 = (int)(l - this.starts_[n2]);
            int n4 = 0;
            while (n > 0) {
                ByteBuffer byteBuffer;
                int n5 = (int)Math.min((long)n, this.ends_[n2] - (long)n3);
                ByteBuffer byteBuffer2 = byteBuffer = this.banks_[n2].byteBuffer_;
                synchronized (byteBuffer2) {
                    byteBuffer.position(n3);
                    byteBuffer.get(byArray, n4, n5);
                }
                n -= n5;
                n4 += n5;
                n3 = 0;
                ++n2;
            }
            return new Bank(ByteBuffer.wrap(byArray), l, this.isBigendian());
        }

        @Override
        public List<Bank> getExistingBanks() {
            return Arrays.asList(this.banks_);
        }

        @Override
        public Iterator<Bank> getBankIterator(long l) {
            Iterator<Bank> iterator = Arrays.asList(this.banks_).iterator();
            for (int i = 0; i < this.banks_.length; ++i) {
                if (l >= this.starts_[i]) {
                    return iterator;
                }
                iterator.next();
            }
            return iterator;
        }

        private static long sumSizes(ByteBuffer[] byteBufferArray) {
            long l = 0L;
            for (int i = 0; i < byteBufferArray.length; ++i) {
                l += (long)byteBufferArray[i].capacity();
            }
            return l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleBankBuf
    extends BankBuf {
        private final Bank bank_;

        SingleBankBuf(ByteBuffer byteBuffer, boolean bl, boolean bl2) {
            super(byteBuffer.capacity(), bl, bl2);
            this.bank_ = new Bank(byteBuffer, 0L, bl2);
        }

        @Override
        public Bank getBank(long l, int n) {
            return this.bank_;
        }

        @Override
        public List<Bank> getExistingBanks() {
            return Collections.singletonList(this.bank_);
        }

        @Override
        public Iterator<Bank> getBankIterator(long l) {
            return Collections.singletonList(this.bank_).iterator();
        }
    }
}

