/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.cdf;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.bristol.star.cdf.AttributeEntry;
import uk.ac.bristol.star.cdf.CdfContent;
import uk.ac.bristol.star.cdf.DataType;
import uk.ac.bristol.star.cdf.GlobalAttribute;
import uk.ac.bristol.star.cdf.Shaper;
import uk.ac.bristol.star.cdf.Variable;
import uk.ac.bristol.star.cdf.VariableAttribute;
import uk.ac.starlink.cdf.CdfDomains;
import uk.ac.starlink.cdf.CdfTableProfile;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;

public class CdfStarTable
extends AbstractStarTable {
    private final Variable[] vars_;
    private final VariableReader[] randomVarReaders_;
    private final int ncol_;
    private final long nrow_;
    private final ColumnInfo[] colInfos_;
    private final VariableAttribute blankvalAtt_;
    private static final Logger logger_ = Logger.getLogger(CdfStarTable.class.getName());
    private static final boolean STIL_ROW_MAJOR = false;

    public CdfStarTable(CdfContent content, CdfTableProfile profile) throws IOException {
        ArrayList<Variable> varList = new ArrayList<Variable>(Arrays.asList(content.getVariables()));
        ArrayList<Variable> paramVarList = new ArrayList<Variable>();
        if (profile.invariantVariablesToParameters()) {
            Iterator it = varList.iterator();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                if (var.getRecordVariance()) continue;
                it.remove();
                paramVarList.add(var);
            }
        }
        Variable[] paramVars = paramVarList.toArray(new Variable[0]);
        this.vars_ = varList.toArray(new Variable[0]);
        this.ncol_ = this.vars_.length;
        long nrow = 0L;
        for (int iv = 0; iv < this.vars_.length; ++iv) {
            nrow = Math.max(nrow, (long)this.vars_[iv].getRecordCount());
        }
        this.nrow_ = nrow;
        VariableAttribute[] vatts = content.getVariableAttributes();
        String[] attNames = new String[vatts.length];
        for (int iva = 0; iva < vatts.length; ++iva) {
            attNames[iva] = vatts[iva].getName();
        }
        String descAttName = profile.getDescriptionAttribute(attNames);
        String unitAttName = profile.getUnitAttribute(attNames);
        String blankvalAttName = profile.getBlankValueAttribute(attNames);
        VariableAttribute descAtt = null;
        VariableAttribute unitAtt = null;
        VariableAttribute blankvalAtt = null;
        for (int iva = 0; iva < vatts.length; ++iva) {
            VariableAttribute vatt = vatts[iva];
            String vattName = vatt.getName();
            if (vattName == null) continue;
            if (vattName.equals(descAttName)) {
                descAtt = vatt;
                continue;
            }
            if (vattName.equals(unitAttName)) {
                unitAtt = vatt;
                continue;
            }
            if (!vattName.equals(blankvalAttName)) continue;
            blankvalAtt = vatt;
        }
        this.blankvalAtt_ = blankvalAtt;
        ArrayList<VariableAttribute> miscAttList = new ArrayList<VariableAttribute>(Arrays.asList(vatts));
        miscAttList.remove(descAtt);
        miscAttList.remove(unitAtt);
        this.randomVarReaders_ = new VariableReader[this.ncol_];
        for (int iv = 0; iv < this.ncol_; ++iv) {
            this.randomVarReaders_[iv] = CdfStarTable.createVariableReader(this.vars_[iv], this.blankvalAtt_);
        }
        this.colInfos_ = new ColumnInfo[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            Variable var = this.vars_[icol];
            LinkedHashMap<String, Object> miscAttMap = new LinkedHashMap<String, Object>();
            for (VariableAttribute vatt : miscAttList) {
                AttributeEntry entry;
                if (vatt == this.blankvalAtt_ && this.randomVarReaders_[icol].usesBlankValue() || (entry = vatt.getEntry(var)) == null) continue;
                miscAttMap.put(vatt.getName(), entry.getShapedValue());
            }
            this.colInfos_[icol] = CdfStarTable.createColumnInfo(var, CdfStarTable.getStringEntry(descAtt, var), CdfStarTable.getStringEntry(unitAtt, var), miscAttMap);
        }
        for (int ipv = 0; ipv < paramVars.length; ++ipv) {
            Variable pvar = paramVars[ipv];
            ValueInfo info = CdfStarTable.createValueInfo(pvar, CdfStarTable.getStringEntry(descAtt, pvar), CdfStarTable.getStringEntry(unitAtt, pvar));
            Object value = CdfStarTable.createVariableReader(pvar, this.blankvalAtt_).readShapedRecord(0);
            this.setParameter(new DescribedValue(info, value));
        }
        GlobalAttribute[] gatts = content.getGlobalAttributes();
        for (int iga = 0; iga < gatts.length; ++iga) {
            DescribedValue dval = CdfStarTable.createParameter(gatts[iga]);
            if (dval == null) continue;
            this.setParameter(dval);
        }
    }

    public int getColumnCount() {
        return this.ncol_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public boolean isRandom() {
        return true;
    }

    public Object getCell(long irow, int icol) throws IOException {
        return this.randomVarReaders_[icol].readShapedRecord(CdfStarTable.toRecordIndex(irow));
    }

    public RowSequence getRowSequence() throws IOException {
        final VariableReader[] vrdrs = new VariableReader[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            vrdrs[icol] = CdfStarTable.createVariableReader(this.vars_[icol], this.blankvalAtt_);
        }
        return new RowSequence(){
            private long irow = -1L;

            public boolean next() {
                return ++this.irow < CdfStarTable.this.nrow_;
            }

            public Object getCell(int icol) throws IOException {
                return vrdrs[icol].readShapedRecord(CdfStarTable.toRecordIndex(this.irow));
            }

            public Object[] getRow() throws IOException {
                Object[] row = new Object[CdfStarTable.this.ncol_];
                for (int icol = 0; icol < CdfStarTable.this.ncol_; ++icol) {
                    row[icol] = this.getCell(icol);
                }
                return row;
            }

            public void close() {
            }
        };
    }

    private static DescribedValue createParameter(GlobalAttribute gatt) {
        Object array;
        String name = gatt.getName();
        AttributeEntry[] entries = gatt.getEntries();
        int nent = entries.length;
        if (nent == 0) {
            return null;
        }
        if (nent == 1) {
            Object value = entries[0].getShapedValue();
            if (value == null) {
                return null;
            }
            DefaultValueInfo info = new DefaultValueInfo(name, value.getClass(), null);
            return new DescribedValue((ValueInfo)info, value);
        }
        try {
            array = CdfStarTable.getValueArray(entries);
        }
        catch (RuntimeException e) {
            logger_.log(Level.WARNING, "Omitting complicated global attribute " + gatt.getName(), e);
            return null;
        }
        DefaultValueInfo info = new DefaultValueInfo(name, array.getClass(), null);
        info.setShape(new int[]{Array.getLength(array)});
        return new DescribedValue((ValueInfo)info, array);
    }

    private static Object getValueArray(AttributeEntry[] entries) {
        int nent = entries.length;
        assert (nent > 1);
        DataType dtype = entries[0].getDataType();
        boolean allScalar = true;
        for (int i = 1; i < nent; ++i) {
            AttributeEntry entry = entries[i];
            if (entry.getDataType() != dtype) {
                dtype = null;
            }
            allScalar = allScalar && entry.getItemCount() == 1;
        }
        if (dtype == null || !allScalar) {
            Object[] array = new Object[nent];
            for (int i = 0; i < nent; ++i) {
                array[i] = entries[i].getShapedValue();
            }
            return array;
        }
        Class<?> elClass = dtype.getArrayElementClass();
        Object array = Array.newInstance(elClass, nent);
        for (int i = 0; i < nent; ++i) {
            Array.set(array, i, entries[i].getShapedValue());
        }
        return array;
    }

    private static ValueInfo createValueInfo(Variable var, String descrip, String units) {
        DomainMapper[] domainMapperArray;
        int[] shape;
        String name = var.getName();
        Class<?> clazz = var.getShaper().getShapeClass();
        DataType dtype = var.getDataType();
        int grpSize = dtype.getGroupSize();
        if (grpSize == 1) {
            shape = clazz.getComponentType() == null ? null : var.getShaper().getDimSizes();
        } else {
            assert (clazz.getComponentType() != null);
            int[] shDims = var.getShaper().getDimSizes();
            shape = new int[shDims.length + 1];
            shape[0] = grpSize;
            System.arraycopy(shDims, 0, shape, 1, shDims.length);
        }
        DefaultValueInfo info = new DefaultValueInfo(name, clazz, descrip);
        info.setUnitString(units);
        info.setShape(shape);
        DomainMapper mapper = CdfDomains.getMapper(dtype);
        if (mapper == null) {
            domainMapperArray = new DomainMapper[]{};
        } else {
            DomainMapper[] domainMapperArray2 = new DomainMapper[1];
            domainMapperArray = domainMapperArray2;
            domainMapperArray2[0] = mapper;
        }
        info.setDomainMappers(domainMapperArray);
        return info;
    }

    private static ColumnInfo createColumnInfo(Variable var, String descrip, String units, Map<String, Object> attMap) {
        ColumnInfo info = new ColumnInfo(CdfStarTable.createValueInfo(var, descrip, units));
        ArrayList<DescribedValue> auxData = new ArrayList<DescribedValue>();
        for (Map.Entry<String, Object> attEntry : attMap.entrySet()) {
            String auxName = attEntry.getKey();
            Object auxValue = attEntry.getValue();
            if (auxValue == null) continue;
            DefaultValueInfo auxInfo = new DefaultValueInfo(auxName, auxValue.getClass());
            auxData.add(new DescribedValue((ValueInfo)auxInfo, auxValue));
        }
        DataType dtype = var.getDataType();
        if (dtype == DataType.UINT1) {
            assert (dtype.getByteCount() == 1);
            assert (dtype.getScalarClass() == Short.class);
            auxData.add(new DescribedValue(Tables.UBYTE_FLAG_INFO, (Object)Boolean.TRUE));
        }
        info.setAuxData(auxData);
        return info;
    }

    private static String getStringEntry(VariableAttribute att, Variable var) {
        AttributeEntry entry = att == null ? null : att.getEntry(var);
        Object item = entry == null ? null : entry.getShapedValue();
        return item instanceof String ? (String)item : null;
    }

    private static int toRecordIndex(long irow) {
        int irec = (int)irow;
        if ((long)irec != irow) {
            throw new IllegalArgumentException("Out of range: " + irow);
        }
        if (irec < 0) {
            throw new IllegalStateException("No row");
        }
        return irec;
    }

    private static VariableReader createVariableReader(Variable var, VariableAttribute blankvalAtt) {
        AttributeEntry blankvalEntry = blankvalAtt == null ? null : blankvalAtt.getEntry(var);
        final Object blankval = blankvalEntry == null ? null : blankvalEntry.getShapedValue();
        Shaper shaper = var.getShaper();
        if (blankval == null) {
            return new VariableReader(var, false);
        }
        if (shaper.getRawItemCount() == 1) {
            return new VariableReader(var, true){

                @Override
                public synchronized Object readShapedRecord(int irec) throws IOException {
                    Object obj = super.readShapedRecord(irec);
                    return blankval.equals(obj) ? null : obj;
                }
            };
        }
        if (double[].class.equals(shaper.getShapeClass()) && blankval instanceof Number && !Double.isNaN(((Number)blankval).doubleValue())) {
            final double dBlank = ((Number)blankval).doubleValue();
            return new VariableReader(var, true){

                @Override
                public synchronized Object readShapedRecord(int irec) throws IOException {
                    Object obj = super.readShapedRecord(irec);
                    if (obj instanceof double[]) {
                        double[] darr = (double[])obj;
                        for (int i = 0; i < darr.length; ++i) {
                            if (darr[i] != dBlank) continue;
                            darr[i] = Double.NaN;
                        }
                    } else assert (false);
                    return obj;
                }
            };
        }
        if (float[].class.equals(shaper.getShapeClass()) && blankval instanceof Number && !Float.isNaN(((Number)blankval).floatValue())) {
            final float fBlank = ((Number)blankval).floatValue();
            return new VariableReader(var, true){

                @Override
                public synchronized Object readShapedRecord(int irec) throws IOException {
                    Object obj = super.readShapedRecord(irec);
                    if (obj instanceof float[]) {
                        float[] farr = (float[])obj;
                        for (int i = 0; i < farr.length; ++i) {
                            if (farr[i] != fBlank) continue;
                            farr[i] = Float.NaN;
                        }
                    } else assert (false);
                    return obj;
                }
            };
        }
        logger_.info("Magic value " + blankvalAtt.getName() + "=" + String.valueOf(blankval) + " ignored for non-float array CDF variable " + var.getName());
        return new VariableReader(var, false);
    }

    private static class VariableReader {
        private final Variable var_;
        private final boolean usesBlankValue_;
        private final Object work_;

        VariableReader(Variable var, boolean usesBlankValue) {
            this.var_ = var;
            this.usesBlankValue_ = usesBlankValue;
            this.work_ = var.createRawValueArray();
        }

        synchronized Object readShapedRecord(int irec) throws IOException {
            return this.var_.readShapedRecord(irec, false, this.work_);
        }

        boolean usesBlankValue() {
            return this.usesBlankValue_;
        }
    }
}

