/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.cdf;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import uk.ac.bristol.star.cdf.CdfContent;
import uk.ac.bristol.star.cdf.CdfReader;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Bufs;
import uk.ac.bristol.star.cdf.record.WrapperBuf;
import uk.ac.starlink.cdf.CdfStarTable;
import uk.ac.starlink.cdf.CdfTableProfile;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;
import uk.ac.starlink.util.IOUtils;

public class CdfTableBuilder
implements TableBuilder {
    public static final CdfTableProfile DEFAULT_PROFILE = CdfTableBuilder.createProfile(true, new String[]{"CATDESC", "FIELDNAM", "DESCRIP", "DESCRIPTION"}, new String[]{"UNITS", "UNIT", "UNITSTRING"}, new String[]{"FILLVAL"});
    private final CdfTableProfile profile_;

    public CdfTableBuilder() {
        this(DEFAULT_PROFILE);
    }

    public CdfTableBuilder(CdfTableProfile profile) {
        this.profile_ = profile;
    }

    public String getFormatName() {
        return "CDF";
    }

    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        Buf nbuf;
        if (!CdfReader.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Not a CDF file");
        }
        if (datsrc instanceof FileDataSource && datsrc.getCompression() == Compression.NONE) {
            File file = ((FileDataSource)datsrc).getFile();
            nbuf = Bufs.createBuf(file, true, true);
        } else {
            ByteStore byteStore = storagePolicy.makeByteStore();
            BufferedOutputStream storeOut = new BufferedOutputStream(byteStore.getOutputStream());
            InputStream dataIn = datsrc.getInputStream();
            IOUtils.copy((InputStream)dataIn, (OutputStream)storeOut);
            dataIn.close();
            storeOut.flush();
            ByteBuffer[] bbufs = byteStore.toByteBuffers();
            storeOut.close();
            byteStore.close();
            nbuf = Bufs.createBuf(bbufs, true, true);
        }
        StoragePolicyBuf buf = new StoragePolicyBuf(nbuf, storagePolicy);
        CdfContent content = new CdfContent(new CdfReader(buf));
        return new CdfStarTable(content, this.profile_);
    }

    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        throw new TableFormatException("Can't stream from CDF format");
    }

    public static CdfTableProfile createProfile(boolean invarParams, String[] descripAttNames, String[] unitAttNames, String[] blankvalAttNames) {
        return new ListCdfTableProfile(invarParams, descripAttNames, unitAttNames, blankvalAttNames);
    }

    private static class ListCdfTableProfile
    implements CdfTableProfile {
        private final boolean invarParams_;
        private final String[] descAttNames_;
        private final String[] unitAttNames_;
        private final String[] blankvalAttNames_;

        ListCdfTableProfile(boolean invarParams, String[] descripAttNames, String[] unitAttNames, String[] blankvalAttNames) {
            this.invarParams_ = invarParams;
            this.descAttNames_ = descripAttNames;
            this.unitAttNames_ = unitAttNames;
            this.blankvalAttNames_ = blankvalAttNames;
        }

        @Override
        public boolean invariantVariablesToParameters() {
            return this.invarParams_;
        }

        @Override
        public String getDescriptionAttribute(String[] attNames) {
            return this.match(this.descAttNames_, attNames);
        }

        @Override
        public String getUnitAttribute(String[] attNames) {
            return this.match(this.unitAttNames_, attNames);
        }

        @Override
        public String getBlankValueAttribute(String[] attNames) {
            return this.match(this.blankvalAttNames_, attNames);
        }

        private String match(String[] opts, String[] targets) {
            int i;
            HashSet<String> targetSet = new HashSet<String>();
            for (i = 0; i < targets.length; ++i) {
                targetSet.add(this.normalise(targets[i]));
            }
            for (i = 0; i < opts.length; ++i) {
                String opt = opts[i];
                if (!targetSet.contains(this.normalise(opt))) continue;
                return opt;
            }
            return null;
        }

        private String normalise(String txt) {
            return txt.trim().toLowerCase();
        }
    }

    private static class StoragePolicyBuf
    extends WrapperBuf {
        private final Buf baseBuf_;
        private final StoragePolicy storagePolicy_;

        StoragePolicyBuf(Buf baseBuf, StoragePolicy storagePolicy) {
            super(baseBuf);
            this.baseBuf_ = baseBuf;
            this.storagePolicy_ = storagePolicy;
        }

        @Override
        public Buf fillNewBuf(long count, InputStream in) throws IOException {
            ByteStore byteStore = this.storagePolicy_.makeByteStore();
            OutputStream out = byteStore.getOutputStream();
            int bufsiz = 16384;
            byte[] a = new byte[bufsiz];
            int ntot = 0;
            while ((long)ntot < count) {
                int n = in.read(a, 0, Math.min(bufsiz, (int)(count - (long)ntot)));
                if (n < 0) {
                    throw new IOException("Stream ended after " + ntot + "/" + count + " bytes");
                }
                out.write(a, 0, n);
                ntot += n;
            }
            out.flush();
            ByteBuffer[] bbufs = byteStore.toByteBuffers();
            byteStore.close();
            return Bufs.createBuf(bbufs, super.isBit64(), super.isBigendian());
        }
    }
}

