/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.gbin;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GbinObjectReader {
    private final Object gbinReaderObj_;
    private final Method hasNextMethod_;
    private final Method nextMethod_;
    private static final Object[] ARGS0 = new Object[0];
    private static boolean isGaiaToolsInit_;
    private static final Logger logger_;

    public GbinObjectReader(Object gbinReaderObj) {
        this.gbinReaderObj_ = gbinReaderObj;
        Class<?> clazz = gbinReaderObj.getClass();
        this.hasNextMethod_ = GbinObjectReader.getNoArgMethod(clazz, "hasNext", Boolean.TYPE);
        this.nextMethod_ = GbinObjectReader.getNoArgMethod(clazz, "next", null);
    }

    public boolean hasNext() throws IOException {
        return Boolean.TRUE.equals(this.invokeNoArgMethod(this.hasNextMethod_));
    }

    public Object next() throws IOException {
        return this.invokeNoArgMethod(this.nextMethod_);
    }

    private Object invokeNoArgMethod(Method method) throws IOException {
        try {
            return method.invoke(this.gbinReaderObj_, ARGS0);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable targetEx = e.getTargetException();
            if (targetEx instanceof ClassNotFoundException) {
                throw (IOException)new IOException("Missing GBIN object class - probably lacking DM jars").initCause(e);
            }
            throw (IOException)new IOException(targetEx.getMessage()).initCause(e);
        }
    }

    private static Method getNoArgMethod(Class<?> clazz, String name, Class<?> retClazz) {
        Method method;
        try {
            method = clazz.getMethod(name, new Class[0]);
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || !Modifier.isPublic(mods) || retClazz != null && !retClazz.equals(method.getReturnType())) {
                method = null;
            }
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        if (method == null) {
            throw new IllegalArgumentException("Object of class " + clazz.getName() + " is not a GbinReader" + " (no suitable " + name + "()" + " method)");
        }
        return method;
    }

    public static GbinObjectReader createReader(InputStream in) throws IOException {
        GbinObjectReader.initGaiaTools();
        return new GbinObjectReader(GbinObjectReader.createGbinReaderObject(in));
    }

    public static boolean isMagic(byte[] intro) {
        if (intro.length < 13) {
            return false;
        }
        long magic = ((long)intro[7] & 0xFFL) << 56 | ((long)intro[6] & 0xFFL) << 48 | ((long)intro[5] & 0xFFL) << 40 | ((long)intro[4] & 0xFFL) << 32 | ((long)intro[3] & 0xFFL) << 24 | ((long)intro[2] & 0xFFL) << 16 | ((long)intro[1] & 0xFFL) << 8 | ((long)intro[0] & 0xFFL) << 0;
        if ((magic & 0xFFFFL) == 60844L) {
            int jserVers = (intro[2] & 0xFF) << 8 | (intro[3] & 0xFF) << 0;
            logger_.info("Java serialised stream, may be GBIN v2 file (java serialization version " + jserVers + ")");
            return true;
        }
        if (magic == 1876326824640923529L) {
            int gbinVers = (intro[9] & 0xFF) << 24 | (intro[10] & 0xFF) << 16 | (intro[11] & 0xFF) << 8 | (intro[12] & 0xFF) << 0;
            logger_.info("Post-v2 GBIN file identified (GBIN version " + gbinVers + ")");
            return true;
        }
        return false;
    }

    public static synchronized void initGaiaTools() {
        if (!isGaiaToolsInit_) {
            String loaderClassName = "gaia.cu1.tools.util.props.PropertyLoader";
            String loaderMethodName = "load";
            String sig = loaderClassName + "." + loaderMethodName + "()";
            logger_.info("Invoking " + sig);
            try {
                Class.forName(loaderClassName).getMethod(loaderMethodName, new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                logger_.log(Level.WARNING, "Failed to invoke " + sig, e);
            }
            isGaiaToolsInit_ = true;
        }
    }

    public static Object createGbinReaderObject(InputStream in) throws IOException {
        try {
            Class<?> factClazz = Class.forName("gaia.cu1.tools.dal.gbin.GbinFactory");
            Method getReaderMethod = factClazz.getMethod("getGbinReader", InputStream.class);
            try {
                return getReaderMethod.invoke(null, in);
            }
            catch (IllegalArgumentException e) {
                throw (IOException)new IOException("Problem with GaiaTools classes").initCause(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("GaiaTools classes not available?").initCause(e);
        }
        catch (NoSuchMethodException e) {
            throw (IOException)new IOException("Problem with GaiaTools classes").initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new IOException("Problem with GaiaTools classes").initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (IOException)new IOException(e.getTargetException().getMessage()).initCause(e);
        }
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.gbin");
    }
}

