/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.gbin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.gbin.GaiaTableMetadata;
import uk.ac.starlink.gbin.GbinMetadataReader;
import uk.ac.starlink.gbin.GbinObjectReader;
import uk.ac.starlink.gbin.GbinTableBuilder;
import uk.ac.starlink.gbin.GbinTableProfile;
import uk.ac.starlink.gbin.ItemReader;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;

public abstract class GbinStarTable
extends AbstractStarTable {
    private final Class<?> gobjClazz_;
    private final int ncol_;
    private final ItemReader[] itemReaders_;
    private final ColumnInfo[] colInfos_;

    protected GbinStarTable(GbinTableProfile profile, Class<?> gobjClazz) {
        ItemReader irdr;
        int ic;
        String descrip;
        GaiaTableMetadata tmeta;
        this.gobjClazz_ = gobjClazz;
        this.setParameter(new DescribedValue(GbinTableBuilder.CLASSNAME_INFO, gobjClazz.getName()));
        String gaiaTableName = GbinMetadataReader.getGaiaTableName(gobjClazz);
        if (gaiaTableName != null) {
            this.setName(gaiaTableName);
            this.setParameter(new DescribedValue(GbinTableBuilder.GAIATABLENAME_INFO, gaiaTableName));
            tmeta = GbinMetadataReader.getTableMetadata(gaiaTableName);
        } else {
            tmeta = null;
        }
        if (tmeta != null && (descrip = tmeta.getTableDescription()) != null) {
            this.setParameter(new DescribedValue(GbinTableBuilder.DESCRIP_INFO, descrip));
        }
        this.itemReaders_ = ItemReader.createItemReaders(gobjClazz, profile);
        this.ncol_ = this.itemReaders_.length;
        HashMap<String, List<ItemReader>> nameMap = new HashMap<String, List<ItemReader>>();
        boolean forceHier = profile.isHierarchicalNames();
        String separator = profile.getNameSeparator();
        if (!forceHier) {
            for (ic = 0; ic < this.ncol_; ++ic) {
                irdr = this.itemReaders_[ic];
                String name = irdr.getItemName();
                if (!nameMap.containsKey(name)) {
                    nameMap.put(name, new ArrayList());
                }
                ((List)nameMap.get(name)).add(irdr);
            }
        }
        this.colInfos_ = new ColumnInfo[this.ncol_];
        for (ic = 0; ic < this.ncol_; ++ic) {
            String detail;
            List<?> ucdList;
            ColumnInfo cinfo;
            irdr = this.itemReaders_[ic];
            String cname = ItemReader.getColumnName(irdr, nameMap, forceHier, separator);
            this.colInfos_[ic] = cinfo = new ColumnInfo(cname, irdr.getItemContentClass(), null);
            String archName = GbinMetadataReader.convertNameToArchiveFormat(cinfo.getName());
            if (archName != null) {
                cinfo.setName(archName);
            }
            if (tmeta == null) continue;
            String descrip2 = tmeta.getParameterDescription(cname);
            if (descrip2 != null && descrip2.trim().length() > 0) {
                cinfo.setDescription(descrip2);
            }
            if ((ucdList = tmeta.getUcds(cname)) != null && ucdList.size() > 0) {
                StringBuffer ucdBuf = new StringBuffer();
                for (Object ucd : ucdList) {
                    if (ucdBuf.length() > 0) {
                        ucdBuf.append(";");
                    }
                    ucdBuf.append(ucd);
                }
                if (ucdBuf.length() > 0) {
                    cinfo.setUCD(ucdBuf.toString());
                }
            }
            if ((detail = tmeta.getParameterDetailedDescription(cname)) == null || detail.trim().length() <= 0) continue;
            cinfo.setAuxDatum(new DescribedValue(GbinTableBuilder.COLDETAIL_INFO, detail));
        }
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public RowSequence createRowSequence(final GbinObjectReader reader, final Object gobj0) {
        final HashMap itemMap = new HashMap();
        return new RowSequence(){
            boolean started;

            @Override
            public boolean next() throws IOException {
                itemMap.clear();
                if (this.started) {
                    if (reader.hasNext()) {
                        itemMap.put(ItemReader.ROOT, reader.next());
                        return true;
                    }
                    return false;
                }
                this.started = true;
                itemMap.put(ItemReader.ROOT, gobj0);
                return true;
            }

            @Override
            public Object getCell(int icol) throws IOException {
                return GbinStarTable.this.itemReaders_[icol].readItem(itemMap);
            }

            @Override
            public Object[] getRow() throws IOException {
                Object[] row = new Object[GbinStarTable.this.ncol_];
                for (int ic = 0; ic < GbinStarTable.this.ncol_; ++ic) {
                    row[ic] = GbinStarTable.this.itemReaders_[ic].readItem(itemMap);
                }
                return row;
            }

            @Override
            public void close() {
            }
        };
    }

    public Class<?> getGaiaObjectClass() {
        return this.gobjClazz_;
    }

    ItemReader[] getItemReaders() {
        return this.itemReaders_;
    }

    public static <T> GbinStarTable createCollectionTable(GbinTableProfile profile, Class<T> gobjClazz, final Collection<? extends T> gobjList) {
        return new GbinStarTable(profile, gobjClazz){

            @Override
            public long getRowCount() {
                return gobjList.size();
            }

            @Override
            public RowSequence getRowSequence() {
                final Iterator it = gobjList.iterator();
                final HashMap itemMap = new HashMap();
                final ItemReader[] itemReaders = this.getItemReaders();
                final int ncol = itemReaders.length;
                return new RowSequence(){

                    @Override
                    public boolean next() {
                        itemMap.clear();
                        if (it.hasNext()) {
                            itemMap.put(ItemReader.ROOT, it.next());
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Object getCell(int icol) throws IOException {
                        return itemReaders[icol].readItem(itemMap);
                    }

                    @Override
                    public Object[] getRow() throws IOException {
                        Object[] row = new Object[ncol];
                        for (int ic = 0; ic < ncol; ++ic) {
                            row[ic] = itemReaders[ic].readItem(itemMap);
                        }
                        return row;
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }
}

