/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.gbin;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.gbin.DefaultGbinTableProfile;
import uk.ac.starlink.gbin.GbinMeta;
import uk.ac.starlink.gbin.GbinMetadataReader;
import uk.ac.starlink.gbin.GbinObjectReader;
import uk.ac.starlink.gbin.GbinStarTable;
import uk.ac.starlink.gbin.GbinTableProfile;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperRowSequence;
import uk.ac.starlink.util.DataSource;

public class GbinTableBuilder
implements TableBuilder {
    private final GbinTableProfile profile_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.gbin");
    public static final ValueInfo CLASSNAME_INFO = new DefaultValueInfo("GbinClass", String.class, "Classname of GBIN objects");
    public static final ValueInfo GAIATABLENAME_INFO = new DefaultValueInfo("GaiaTableName", String.class, "Well-known name of Gaia table");
    public static final ValueInfo DESCRIP_INFO = new DefaultValueInfo("Description", String.class, "Table description from Gaia data model");
    public static final ValueInfo COLDETAIL_INFO = new DefaultValueInfo("GaiaDetail", String.class, "Detailed column description from Gaia data model");
    public static final ValueInfo BUILDDESCRIP_INFO = new DefaultValueInfo("GbinDescription", String.class, "GBIN build description");

    public GbinTableBuilder() {
        this(new DefaultGbinTableProfile());
    }

    public GbinTableBuilder(GbinTableProfile profile) {
        this.profile_ = profile;
    }

    public GbinTableProfile getProfile() {
        return this.profile_;
    }

    @Override
    public String getFormatName() {
        return "GBIN";
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        try {
            GbinObjectReader reader = GbinObjectReader.createReader(in);
            if (!reader.hasNext()) {
                throw new IOException("No objects in GBIN file");
            }
            Object gobj0 = reader.next();
            GbinStarTable table = new GbinStarTable(this.profile_, gobj0.getClass()){

                @Override
                public long getRowCount() {
                    return -1L;
                }

                @Override
                public RowSequence getRowSequence() {
                    throw new UnsupportedOperationException();
                }
            };
            sink.acceptMetadata(table);
            RowSequence rseq = table.createRowSequence(reader, gobj0);
            while (rseq.next()) {
                sink.acceptRow(rseq.getRow());
            }
            sink.endRows();
            rseq.close();
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StarTable makeStarTable(final DataSource datsrc, boolean wantRandom, StoragePolicy storage) throws IOException {
        long nrow;
        if (this.profile_.isTestMagic() && !GbinObjectReader.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Not GBIN");
        }
        BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());
        GbinObjectReader rdr = GbinObjectReader.createReader(in);
        if (!rdr.hasNext()) {
            throw new IOException("No objects in GBIN file");
        }
        Class<?> gobjClazz = rdr.next().getClass();
        ((InputStream)in).close();
        ArrayList<DescribedValue> params = new ArrayList<DescribedValue>();
        if (this.profile_.isReadMeta()) {
            Long nrowObj;
            BufferedInputStream metaIn = new BufferedInputStream(datsrc.getInputStream());
            try {
                Object gbinRdrObj = GbinObjectReader.createGbinReaderObject(metaIn);
                GbinMeta meta = GbinMetadataReader.attemptReadMetadata(gbinRdrObj);
                nrowObj = meta.getTotalElementCount();
                params.add(new DescribedValue(BUILDDESCRIP_INFO, meta.buildDescription(false)));
            }
            catch (Throwable e) {
                nrowObj = null;
                logger_.log(Level.WARNING, "Couldn't read GBIN metadata", e);
            }
            finally {
                ((InputStream)metaIn).close();
            }
            nrow = nrowObj == null ? -1L : nrowObj;
        } else {
            nrow = -1L;
        }
        final long nrow0 = nrow;
        GbinStarTable table = new GbinStarTable(this.profile_, gobjClazz){

            @Override
            public RowSequence getRowSequence() throws IOException {
                final BufferedInputStream in = new BufferedInputStream(datsrc.getInputStream());
                GbinObjectReader reader = GbinObjectReader.createReader(in);
                if (!reader.hasNext()) {
                    throw new IOException("No objects in GBIN file");
                }
                Object gobj0 = reader.next();
                return new WrapperRowSequence(this.createRowSequence(reader, gobj0)){

                    @Override
                    public void close() throws IOException {
                        in.close();
                    }
                };
            }

            @Override
            public long getRowCount() {
                return nrow0;
            }
        };
        for (DescribedValue param : params) {
            table.setParameter(param);
        }
        return table;
    }
}

