/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.TableKeeper;
import gnu.jel.debug.Debug;

public class CompilationException
extends Exception {
    public int col = -1;
    private int code = -1;
    private Object[] params = null;

    public CompilationException(int code, Object param) {
        Debug.check(code >= 0);
        this.code = code;
        if (param != null) {
            if (param.getClass().isArray()) {
                this.params = (Object[])param;
            } else {
                Object[] temp = new Object[]{param};
                this.params = temp;
            }
        }
    }

    public int getColumn() {
        return this.col;
    }

    public int getType() {
        return this.code;
    }

    public Object[] getParameters() {
        return this.params;
    }

    public String getMessage() {
        Debug.check(this.col >= 0);
        return TableKeeper.getMsg(this.code, this.params);
    }
}

