/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.debug.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLoader
extends ClassLoader {
    String name;
    byte[] bytes;
    Class<?> c;
    ClassLoader parent;

    private ImageLoader(String name, byte[] bytes) {
        this.name = name;
        this.bytes = bytes;
        this.c = null;
        this.parent = this.getClass().getClassLoader();
    }

    public static Class<?> load(byte[] image) {
        Debug.check(image[10] == 1, "Attempt to load non-JEL generated class file");
        int len = (image[11] << 8) + image[12];
        char[] nameChr = new char[len];
        for (int i = 0; i < len; ++i) {
            nameChr[i] = (char)image[13 + i];
        }
        String name = String.copyValueOf(nameChr);
        try {
            ImageLoader il = new ImageLoader(name, image);
            return il.loadClass(name);
        }
        catch (Exception e) {
            Debug.reportThrowable(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!name.equals(this.name)) {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
            return this.findSystemClass(name);
        }
        String string = name;
        synchronized (string) {
            if (this.c == null) {
                this.c = this.defineClass(name, this.bytes, 0, this.bytes.length, this.getClass().getProtectionDomain());
                if (resolve) {
                    this.resolveClass(this.c);
                }
            }
        }
        return this.c;
    }
}

