/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.CombinationDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.XYDataset;
import java.util.ArrayList;
import java.util.List;

public class CombinedDataset
extends AbstractSeriesDataset
implements XYDataset,
HighLowDataset,
IntervalXYDataset,
CombinationDataset {
    private List datasetInfo = new ArrayList();

    public CombinedDataset() {
    }

    public CombinedDataset(SeriesDataset[] seriesDatasetArray) {
        this.add(seriesDatasetArray);
    }

    public void add(SeriesDataset seriesDataset) {
        this.fastAdd(seriesDataset);
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this);
        this.notifyListeners(datasetChangeEvent);
    }

    public void add(SeriesDataset[] seriesDatasetArray) {
        int n = 0;
        while (n < seriesDatasetArray.length) {
            this.fastAdd(seriesDatasetArray[n]);
            ++n;
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this);
        this.notifyListeners(datasetChangeEvent);
    }

    public void add(SeriesDataset seriesDataset, int n) {
        this.add(new SubSeriesDataset(seriesDataset, n));
    }

    private void fastAdd(SeriesDataset seriesDataset) {
        int n = 0;
        while (n < seriesDataset.getSeriesCount()) {
            this.datasetInfo.add(new DatasetInfo(seriesDataset, n));
            ++n;
        }
    }

    public int getSeriesCount() {
        return this.datasetInfo.size();
    }

    public String getSeriesName(int n) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return datasetInfo.data.getSeriesName(datasetInfo.series);
    }

    public Number getXValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getXValue(datasetInfo.series, n2);
    }

    public Number getYValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getYValue(datasetInfo.series, n2);
    }

    public int getItemCount(int n) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getItemCount(datasetInfo.series);
    }

    public Number getHighValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getHighValue(datasetInfo.series, n2);
    }

    public Number getLowValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getLowValue(datasetInfo.series, n2);
    }

    public Number getOpenValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getOpenValue(datasetInfo.series, n2);
    }

    public Number getCloseValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getCloseValue(datasetInfo.series, n2);
    }

    public Number getVolumeValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getVolumeValue(datasetInfo.series, n2);
    }

    public Number getStartXValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getStartXValue(datasetInfo.series, n2);
        }
        return this.getXValue(n, n2);
    }

    public Number getEndXValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getEndXValue(datasetInfo.series, n2);
        }
        return this.getXValue(n, n2);
    }

    public Number getStartYValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getStartYValue(datasetInfo.series, n2);
        }
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getEndYValue(datasetInfo.series, n2);
        }
        return this.getYValue(n, n2);
    }

    public SeriesDataset getParent() {
        SeriesDataset seriesDataset = null;
        int n = 0;
        while (n < this.datasetInfo.size()) {
            SeriesDataset seriesDataset2 = this.getDatasetInfo((int)n).data;
            if (seriesDataset2 instanceof CombinationDataset) {
                SeriesDataset seriesDataset3 = ((CombinationDataset)((Object)seriesDataset2)).getParent();
                if (seriesDataset == null) {
                    seriesDataset = seriesDataset3;
                } else if (seriesDataset != seriesDataset3) {
                    return null;
                }
            } else {
                return null;
            }
            ++n;
        }
        return seriesDataset;
    }

    public int[] getMap() {
        int[] nArray = null;
        int n = 0;
        while (n < this.datasetInfo.size()) {
            int[] nArray2;
            SeriesDataset seriesDataset = this.getDatasetInfo((int)n).data;
            if (seriesDataset instanceof CombinationDataset) {
                nArray2 = ((CombinationDataset)((Object)seriesDataset)).getMap();
                if (nArray2 == null) {
                    return null;
                }
            } else {
                return null;
            }
            nArray = this.joinMap(nArray, nArray2);
            ++n;
        }
        return nArray;
    }

    public int getChildPosition(Dataset dataset) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.datasetInfo.size()) {
            SeriesDataset seriesDataset = this.getDatasetInfo((int)n2).data;
            if (seriesDataset instanceof CombinedDataset) {
                int n3 = ((CombinedDataset)seriesDataset).getChildPosition(dataset);
                if (n3 >= 0) {
                    return n + n3;
                }
                ++n;
            } else {
                if (dataset == seriesDataset) {
                    return n;
                }
                ++n;
            }
            ++n2;
        }
        return -1;
    }

    private DatasetInfo getDatasetInfo(int n) {
        return (DatasetInfo)this.datasetInfo.get(n);
    }

    private int[] joinMap(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2;
        }
        if (nArray2 == null) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private class DatasetInfo {
        SeriesDataset data;
        int series;

        DatasetInfo(SeriesDataset seriesDataset, int n) {
            this.data = seriesDataset;
            this.series = n;
        }
    }
}

