/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractDataset;
import com.jrefinery.data.MeterDataset;

public class DefaultMeterDataset
extends AbstractDataset
implements MeterDataset {
    static final double DEFAULT_ADJ = 1.0;
    Number minCritical;
    Number maxCritical;
    Number minWarning;
    Number maxWarning;
    Number minNormal;
    Number maxNormal;
    Number min;
    Number max;
    Number value;
    int borderType;
    String units;

    public DefaultMeterDataset() {
        this(new Double(0.0), new Double(0.0), null, null);
    }

    public DefaultMeterDataset(Number number, Number number2, Number number3, String string) {
        this(number, number2, number3, string, null, null, null, null, null, null, 0);
    }

    public DefaultMeterDataset(Number number, Number number2, Number number3, String string, Number number4, Number number5, Number number6, Number number7, Number number8, Number number9, int n) {
        this.setRange(number, number2);
        this.setValue(number3);
        this.setUnits(string);
        this.setCriticalRange(number4, number5);
        this.setWarningRange(number6, number7);
        this.setNormalRange(number8, number9);
        this.setBorderType(n);
    }

    public Number getMinimumCriticalValue() {
        return this.minCritical;
    }

    public Number getMaximumCriticalValue() {
        return this.maxCritical;
    }

    public Number getMinimumWarningValue() {
        return this.minWarning;
    }

    public Number getMaximumWarningValue() {
        return this.maxWarning;
    }

    public Number getMinimumNormalValue() {
        return this.minNormal;
    }

    public Number getMaximumNormalValue() {
        return this.maxNormal;
    }

    public Number getMinimumValue() {
        return this.min;
    }

    public Number getMaximumValue() {
        return this.max;
    }

    public Number getValue() {
        return this.value;
    }

    public String getUnits() {
        return this.units;
    }

    public boolean isValueValid() {
        return this.value != null;
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setUnits(String string) {
        this.units = string;
        this.fireDatasetChanged();
    }

    public void setBorderType(int n) {
        this.borderType = n;
        this.fireDatasetChanged();
    }

    public void setValue(Number number) {
        if (number != null && this.min != null && this.max != null && (number.doubleValue() < this.min.doubleValue() || number.doubleValue() > this.max.doubleValue())) {
            throw new IllegalArgumentException("Value is out of range for min/max");
        }
        this.value = number;
        if (number != null && this.min != null && this.max != null && this.min.doubleValue() == this.max.doubleValue()) {
            this.min = new Double(number.doubleValue() - 1.0);
            this.max = new Double(number.doubleValue() + 1.0);
        }
        this.fireDatasetChanged();
    }

    public void setRange(Number number, Number number2) {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("Min/Max should not be null");
        }
        if (number.doubleValue() > number2.doubleValue()) {
            Number number3 = number;
            number = number2;
            number2 = number3;
        }
        if (this.value != null && number.doubleValue() == number2.doubleValue()) {
            number = new Double(this.value.doubleValue() - 1.0);
            number2 = new Double(this.value.doubleValue() + 1.0);
        }
        this.min = number;
        this.max = number2;
        this.fireDatasetChanged();
    }

    public void setNormalRange(Number number, Number number2) {
        this.minNormal = number;
        this.maxNormal = number2;
        if (this.minNormal != null && this.minNormal.doubleValue() < this.min.doubleValue()) {
            this.min = this.minNormal;
        }
        if (this.maxNormal != null && this.maxNormal.doubleValue() > this.max.doubleValue()) {
            this.max = this.maxNormal;
        }
        this.fireDatasetChanged();
    }

    public void setWarningRange(Number number, Number number2) {
        this.minWarning = number;
        this.maxWarning = number2;
        if (this.minWarning != null && this.minWarning.doubleValue() < this.min.doubleValue()) {
            this.min = this.minWarning;
        }
        if (this.maxWarning != null && this.maxWarning.doubleValue() > this.max.doubleValue()) {
            this.max = this.maxWarning;
        }
        this.fireDatasetChanged();
    }

    public void setCriticalRange(Number number, Number number2) {
        this.minCritical = number;
        this.maxCritical = number2;
        if (this.minCritical != null && this.minCritical.doubleValue() < this.min.doubleValue()) {
            this.min = this.minCritical;
        }
        if (this.maxCritical != null && this.maxCritical.doubleValue() > this.max.doubleValue()) {
            this.max = this.maxCritical;
        }
        this.fireDatasetChanged();
    }
}

