/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.GanttSeries;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.TimeAllocation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GanttSeriesCollection
extends AbstractSeriesDataset
implements IntervalCategoryDataset {
    protected List tasks = new ArrayList();
    protected List data = new ArrayList();

    public String getSeriesName(int n) {
        GanttSeries ganttSeries = (GanttSeries)this.data.get(n);
        return ganttSeries.getName();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public int getCategoryCount() {
        return this.tasks.size();
    }

    public List getCategories() {
        return this.tasks;
    }

    public void add(GanttSeries ganttSeries) {
        this.data.add(ganttSeries);
        Iterator iterator = ganttSeries.tasks.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = this.tasks.indexOf(e);
            if (n >= 0) continue;
            this.tasks.add(e);
        }
    }

    public Number getValue(int n, Object object) {
        GanttSeries ganttSeries = (GanttSeries)this.data.get(n);
        TimeAllocation timeAllocation = ganttSeries.getTimeAllocation(object);
        return new Long(timeAllocation.getStart().getTime());
    }

    public Number getStartValue(int n, Object object) {
        GanttSeries ganttSeries = (GanttSeries)this.data.get(n);
        TimeAllocation timeAllocation = ganttSeries.getTimeAllocation(object);
        return new Long(timeAllocation.getStart().getTime());
    }

    public Number getEndValue(int n, Object object) {
        GanttSeries ganttSeries = (GanttSeries)this.data.get(n);
        TimeAllocation timeAllocation = ganttSeries.getTimeAllocation(object);
        return new Long(timeAllocation.getEnd().getTime());
    }
}

